import java.io.File;
import net.minecraft.src.forge.Configuration;
import net.minecraft.src.BaseMod;
import net.minecraft.src.ic2.api.CropCard;

public class mod_HelperCrops extends BaseMod {
    public static Configuration config = new Configuration(new File("./config/HelperCrops.cfg"));
    public final int cropid_soybean;
    public final int cropid_waterroot;

    public mod_HelperCrops() {
        try {
            config.load();
        } catch (RuntimeException e) {} // Just regenerate the config if it's
                                        // broken.
        String id_strs[] = {
            config.getOrCreateIntProperty("cropid.soybean",
                                          config.CATEGORY_GENERAL, 101).value,
            config.getOrCreateIntProperty("cropid.waterroot",
                                          config.CATEGORY_GENERAL, 102).value,
        };
        config.save();

        int ids[] = new int[id_strs.length];
        try {
            for (int i=0; i<id_strs.length; i++) {
                ids[i] = Integer.parseInt(id_strs[i]);
            }
        } catch (NumberFormatException e) {
        }

        cropid_soybean = ids[0];
        cropid_waterroot = ids[1];
    }

    public void load() {
        CropCard.registerCrop(new SoybeanCrop(), cropid_soybean);
        CropCard.registerCrop(new WaterrootCrop(), cropid_waterroot);
    }

    public String getVersion() {
        return "v4.0";
    }

    public String getPriorities() {
        return "required-after:mod_IC2";
    }
}
