import java.io.File;
import net.minecraft.src.forge.Configuration;
import net.minecraft.src.forge.NetworkMod;
import net.minecraft.src.ic2.api.CropCard;

public class mod_ExperiMint extends NetworkMod {
    public static Configuration config = new Configuration(new File("./config/ExperiMint.cfg"));
    public final int cropid_experimint;

    public mod_ExperiMint() {
        try {
            config.load();
        } catch (RuntimeException e) {} // Just regenerate the config if it's
                                        // broken.
        String id_strs[] = {
            config.getOrCreateIntProperty("cropid.experimint",
                                          config.CATEGORY_GENERAL, 110).value,
        };
        config.save();

        int ids[] = new int[id_strs.length];
        try {
            for (int i=0; i<id_strs.length; i++) {
                ids[i] = Integer.parseInt(id_strs[i]);
            }
        } catch (NumberFormatException e) {
        }

        cropid_experimint = ids[0];
    }

    public void load() {
        CropCard.registerCrop(new ExperiMint(), cropid_experimint);
    }

    public String getVersion() {
        return "v4.0";
    }

    public String getPriorities() {
        return "required-after:mod_IC2";
    }
}
