import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.forge.Configuration;
import net.minecraft.src.forge.MinecraftForgeClient;
import net.minecraft.src.forge.NetworkMod;
import net.minecraft.src.ic2.api.CropCard;
import net.minecraft.src.GuiIngame;

public class mod_DebugCrop extends NetworkMod {
    public static Configuration config = new Configuration(new File(Minecraft.getMinecraftDir(), "config/DebugCrop.cfg"));
    public final int cropid_debugcrop;

    public mod_DebugCrop() {
        try {
            config.load();
        } catch (RuntimeException e) {} // Just regenerate the config if it's
                                        // broken.
        String id_strs[] = {
            config.getOrCreateIntProperty("cropid.debugcrop",
                                          config.CATEGORY_GENERAL, 100).value,
        };
        config.save();

        int ids[] = new int[id_strs.length];
        try {
            for (int i=0; i<id_strs.length; i++) {
                ids[i] = Integer.parseInt(id_strs[i]);
            }
        } catch (NumberFormatException e) {
        }

        cropid_debugcrop = ids[0];
    }

    public void load() {
        CropCard.registerCrop(new DebugCrop(cropid_debugcrop),
                              cropid_debugcrop);
        CropCard.registerBaseSeed(new ItemStack(4, 1, 0), cropid_debugcrop, 1, 10, 10, 10);
        MinecraftForgeClient.preloadTexture("/fm_crops.png");
    }

    public String getVersion() {
        return "v4.0";
    }

    public String getPriorities() {
        return "required-after:mod_IC2";
    }

    public boolean clientSideRequired() {
        return true;
    }

    public boolean serverSideRequired() {
        return false;
    }
}
