package net.minecraft.src;

import net.minecraft.src.*;
import net.minecraft.src.ic2.api.CropCard;
import net.minecraft.src.ic2.api.TECrop;

public class BambooCrop extends CropCard {

    public BambooCrop() {
    }

    public String name() {
        return "Bamboo";
    }

    public String discoveredBy() {
        return "Nekowulf";
    }

    public int tier() {
        return 2;
    }

    public int stat(int n) {
        switch(n) {
        case 0:
            return 3;

        case 1:
            return 0;

        case 2:
            return 0;

        case 3:
            return 3;

        case 4:
            return 0;
            
        default:
        	return 0;
        }
    }

    public String[] attributes() {
        return (new String[] {
            "Stick", "Wood", "Brown"
        });
    }

    public int getSpriteIndex(TECrop crop) {
    	return (int)crop.size - 1;
        }

    public boolean canGrow(TECrop crop) {
        if (crop.size < 3) {
            return true;
        } else {
            return false;
        }
    }

     public boolean canBeHarvested(TECrop crop) {
        return crop.size == 3;
    }

    public ItemStack getGain(TECrop crop) {
        return new ItemStack(Item.stick , mod_ForTheTrees.random.nextInt(4) + 1);
    }

    public byte getSizeAfterHarvest(TECrop crop) {
        return 1;
    }

    public int growthDuration(TECrop crop) {
        return 100;
    }

    public String getTextureFile() {
        return "/ftt_crops.png";
    }
}
