package net.minecraft.src;

import net.minecraft.src.*;
import net.minecraft.src.ic2.api.CropCard;
import net.minecraft.src.ic2.api.TECrop;

public class ApplebushCrop extends CropCard {

    public ApplebushCrop() {
    }

    public String name() {
        return "Apple Bush";
    }

    public String discoveredBy() {
        return "Nekowulf";
    }

    public int tier() {
        return 5;
    }

    public int stat(int n) {
        switch(n) {
        case 0:
            return 0;

        case 1:
            return 4;

        case 2:
            return 0;

        case 3:
            return 3;

        case 4:
            return 0;
            
        default:
        	return 0;
        }
    }

    public String[] attributes() {
        return (new String[] {
            "Apple", "Food", "Red"
        });
    }

    public int getSpriteIndex(TECrop crop) {
    	switch(crop.size) {
    	case 1:
    		return 3;
    		
    	case 2:
    		return 4;
    		
    	case 3:
    		return 6;
    		
    	case 4:
    		return 7;
    		
    	default:
    		return 3;
    	}
        }

    public boolean canGrow(TECrop crop) {
        if (crop.size < 4) {
            return true;
        } else {
            return false;
        }
    }

     public boolean canBeHarvested(TECrop crop) {
        return crop.size == 4;
    }

    public ItemStack getGain(TECrop crop) {
        return new ItemStack(Item.appleRed, mod_ForTheTrees.random.nextInt(2) + 1);
    }

    public byte getSizeAfterHarvest(TECrop crop) {
        return 2;
    }

    public int growthDuration(TECrop crop) {
        return 500;
    }

    public String getTextureFile() {
        return "/ftt_crops.png";
    }
}
