package net.minecraft.src;

import net.minecraft.src.*;
import net.minecraft.src.ic2.api.CropCard;
import net.minecraft.src.ic2.api.TECrop;

public class PlanktonCrop extends CropCard {

    public PlanktonCrop() {
    }

    public String name() {
        return "Plank-ton";
    }

    public String discoveredBy() {
        return "Nekowulf";
    }

    public int tier() {
        return 3;
    }

    public int stat(int n) {
        switch(n) {
        case 0:
            return 3;

        case 1:
            return 0;

        case 2:
            return 0;

        case 3:
            return 3;

        case 4:
            return 0;
            
        default:
        	return 0;
        }
    }

    public String[] attributes() {
        return (new String[] {
            "Plank", "Wood", "Brown"
        });
    }

    public int getSpriteIndex(TECrop crop) {
    	return (int)crop.size + 2;
        }

    public boolean canGrow(TECrop crop) {
        if (crop.size < 3) {
            return true;
        } else {
            return false;
        }
    }

     public boolean canBeHarvested(TECrop crop) {
        return crop.size == 3;
    }

    public ItemStack getGain(TECrop crop) {
        return new ItemStack(Block.planks , mod_ForTheTrees.random.nextInt(3) + 1);
    }

    public byte getSizeAfterHarvest(TECrop crop) {
        return 1;
    }

    public int growthDuration(TECrop crop) {
        return 300;
    }

    public String getTextureFile() {
        return "/ftt_crops.png";
    }
}
