package net.minecraft.src;

import java.io.File;
import java.util.Random;
import net.minecraft.src.ic2.api.*;
import net.minecraft.client.Minecraft;
import net.minecraft.src.forge.*;
import net.minecraft.src.BaseMod;
import net.minecraft.src.Block;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ModLoader;



public class mod_ForTheTrees extends BaseMod {
		public static Configuration config = new Configuration(new File(Minecraft.getMinecraftDir(), "config/ForTheTrees.cfg"));
		public final static Random random = new Random( 1492 );
		public final int testMode;
		public final int cropid_apple;
		public final int cropid_bamboo;
		public final int cropid_bshroom;
		public final int cropid_bushwood;
		public final int cropid_cactus;
		public final int cropid_plankton;
		public final int cropid_rshroom;
		public final int cropid_torchweed;
		public final int cropid_flax;
		public final int item_charbriq;
		public final int block_charbrick;
		public final int id_flaxseed;
		public static Item charcoalBriquette;
		public static Block charcoalBrick;
		

		public mod_ForTheTrees() {
			config.load();
			
			testMode = Integer.parseInt(config.getOrCreateIntProperty("testmode", config.CATEGORY_GENERAL, 0).value);
			
			cropid_apple = Integer.parseInt(config.getOrCreateIntProperty("cropid.applebush", config.CATEGORY_GENERAL, 117).value);
			cropid_bamboo = Integer.parseInt(config.getOrCreateIntProperty("cropid.bamboo", config.CATEGORY_GENERAL, 118).value);
			cropid_bshroom = Integer.parseInt(config.getOrCreateIntProperty("cropid.brownshroom", config.CATEGORY_GENERAL, 119).value);
			cropid_bushwood = Integer.parseInt(config.getOrCreateIntProperty("cropid.bushwood", config.CATEGORY_GENERAL, 120).value);
			cropid_cactus = Integer.parseInt(config.getOrCreateIntProperty("cropid.cactus", config.CATEGORY_GENERAL, 121).value);
			cropid_plankton = Integer.parseInt(config.getOrCreateIntProperty("cropid.plankton", config.CATEGORY_GENERAL, 122).value);
			cropid_rshroom = Integer.parseInt(config.getOrCreateIntProperty("cropid.redshroom", config.CATEGORY_GENERAL, 123).value);
			cropid_torchweed = Integer.parseInt(config.getOrCreateIntProperty("cropid.torchweed", config.CATEGORY_GENERAL, 124).value);
			cropid_flax = Integer.parseInt(config.getOrCreateIntProperty("cropid.flax", config.CATEGORY_GENERAL, 125).value);
			
			item_charbriq = Integer.parseInt(config.getOrCreateIntProperty("itemid.charcoalbriquette", config.CATEGORY_ITEM, 12300).value);
			block_charbrick = Integer.parseInt(config.getOrCreateIntProperty("blockid.charcoalbrick", config.CATEGORY_BLOCK, 217).value);
			id_flaxseed = Integer.parseInt(config.getOrCreateIntProperty("itemid.RP2flaxseed", config.CATEGORY_ITEM, 0).value);
			
			config.save();
		}
		
		@Override	
		public String getVersion() {
			return "v1.0";
		}
	
		@Override
		public String getPriorities() {
			return "required-after:mod_IC2";
		}

		@Override
		public void load() {
			MinecraftForgeClient.preloadTexture("/ftt_crops.png");
			
			CropCard.registerCrop(new ApplebushCrop(), cropid_apple);
			CropCard.registerCrop(new BambooCrop(), cropid_bamboo);
			CropCard.registerCrop(new BrownShroomCrop(), cropid_bshroom);
			CropCard.registerCrop(new BushwoodCrop(), cropid_bushwood);
			CropCard.registerCrop(new CactusCrop(), cropid_cactus);
			CropCard.registerCrop(new PlanktonCrop(), cropid_plankton);
			CropCard.registerCrop(new RedShroomCrop(), cropid_rshroom);
			CropCard.registerCrop(new TorchweedCrop(), cropid_torchweed);
			CropCard.registerCrop(new FlaxCrop(), cropid_flax);
			
			CropCard.registerBaseSeed(new ItemStack(Block.mushroomBrown.blockID , 1, -1), cropid_bshroom, 1, 1, 1, 1);
			CropCard.registerBaseSeed(new ItemStack(Block.mushroomRed.blockID, 1, -1), cropid_rshroom, 1, 1, 1, 1);
			CropCard.registerBaseSeed(new ItemStack(Block.cactus.blockID, 1, -1), cropid_cactus, 1, 1, 1, 1);

			if(id_flaxseed > 0)
				CropCard.registerBaseSeed(new ItemStack(id_flaxseed + 256, 1, -1), cropid_flax, 1, 1, 5, 1);

			
			if(testMode == 1) {
				CropCard.registerBaseSeed(new ItemStack(Item.appleRed.shiftedIndex, 1, -1), cropid_apple, 1, 1, 1, 1);
				CropCard.registerBaseSeed(new ItemStack(Block.sapling.blockID, 1, -1), cropid_bamboo, 1, 1, 1, 1);
				CropCard.registerBaseSeed(new ItemStack(Block.wood.blockID, 1, -1), cropid_bushwood, 1, 1, 1, 1);
				CropCard.registerBaseSeed(new ItemStack(Block.planks.blockID, 1, -1), cropid_plankton, 1, 1, 1, 1);
				CropCard.registerBaseSeed(new ItemStack(Block.torchWood, 1, -1), cropid_torchweed, 1, 1, 1, 1);
			}
			
			charcoalBriquette = new ItemCharcoalBriquette(item_charbriq).setIconIndex(15).setItemName("charcoalBriquette");
			charcoalBrick = new BlockCharcoalBrick(block_charbrick, 17).setBlockName("charcoalBrick");
			
			ModLoader.registerBlock(charcoalBrick);
			MinecraftForge.setBlockHarvestLevel(charcoalBrick, "pickaxe", 0);
			
			ModLoader.addName(charcoalBriquette, "Charcoal Briquette");
			ModLoader.addName(charcoalBrick, "Charcoal Brick");
			
			Ic2Recipes.addCompressorRecipe(new ItemStack(Item.coal, 1, 1), new ItemStack(charcoalBriquette, 1));
			Ic2Recipes.addCraftingRecipe(new ItemStack(charcoalBrick, 1), new Object[] {"BBB", "BSB", "BBB", Character.valueOf('B'), charcoalBriquette, Character.valueOf('S'), Item.slimeBall});
			Ic2Recipes.addCraftingRecipe(new ItemStack(charcoalBrick, 1), new Object[] {"BBB", "BRB", "BBB", Character.valueOf('B'), charcoalBriquette, Character.valueOf('R'), Items.getItem("resin") });
		}
		
		@Override
		public int addFuel(int id, int var2)
		{
			if(id == charcoalBriquette.shiftedIndex)
				return 2000;
			
			if(id == charcoalBrick.blockID)
				return 16000;
			
			return 0;
		}
}