package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;
import net.minecraft.src.WorldProviderEnd;
import net.minecraft.src.forge.*;

public class BlockCharcoalBrick extends Block implements ITextureProvider
{
        public BlockCharcoalBrick(int i, int j)
        {
                super(i, j, Material.rock);
                this.setHardness(2F);
                this.setResistance(1F);
                this.setStepSound(Block.soundStoneFootstep);
                Block.setBurnProperties(i, 30, 0);
        }

        public String getTextureFile()
        {
                return "/ftt_crops.png";
        }
        
        @Override
        public boolean isFireSource(World world, int x, int y, int z, int metadata, int face)
        {
        	return face == 0;
        }
}