package net.minecraft.src;

import net.minecraft.src.*;
import net.minecraft.src.ic2.api.CropCard;
import net.minecraft.src.ic2.api.TECrop;

public class RedShroomCrop extends CropCard {

    public RedShroomCrop() {
    }

    public String name() {
        return "Red Mushroom";
    }

    public String discoveredBy() {
        return "Notch";
    }

    public int tier() {
        return 2;
    }

    public int stat(int n) {
        switch(n) {
        case 0:
            return 0;

        case 1:
            return 4;

        case 2:
            return 0;

        case 3:
            return 3;

        case 4:
            return 0;
            
        default:
        	return 0;
        }
    }

    public String[] attributes() {
        return (new String[] {
            "Mushroom", "Food", "Red"
        });
    }

    public int getSpriteIndex(TECrop crop) {
    	return (int)crop.size + 7;
        }

    public boolean canGrow(TECrop crop) {
        if (crop.size < 3)
            return true;
        return false;
    }

    public int weightInfluences(TECrop crop, float hum, float nut, float air) {
    	return (int)((5 * hum + 10 * nut) / crop.getLightLevel());
    }

     public boolean canBeHarvested(TECrop crop) {
        return crop.size == 3;
    }

    public ItemStack getGain(TECrop crop) {
        return new ItemStack(Block.mushroomRed, mod_ForTheTrees.random.nextInt(2) + 1);
    }

    public byte getSizeAfterHarvest(TECrop crop) {
        return 2;
    }

    public int growthDuration(TECrop crop) {
        return 400;
    }

    public String getTextureFile() {
        return "/ftt_crops.png";
    }
}
