package net.minecraft.src;

import net.minecraft.src.*;
import net.minecraft.src.ic2.api.CropCard;
import net.minecraft.src.ic2.api.TECrop;

public class CactusCrop extends CropCard {

    public CactusCrop() {
    }

    public String name() {
        return "Barrel Cactus";
    }

    public String discoveredBy() {
        return "Notch";
    }

    public int tier() {
        return 3;
    }

    public int stat(int n) {
        switch(n) {
        case 0:
            return 3;

        case 1:
            return 0;

        case 2:
            return 1;

        case 3:
            return 3;

        case 4:
            return 0;
            
        default:
        	return 0;
        }
    }

    public String[] attributes() {
        return (new String[] {
            "Cactus", "Pointy", "Green"
        });
    }

    public int getSpriteIndex(TECrop crop) {
    	return (int)crop.size + 11;
        }

    public boolean canGrow(TECrop crop) {
        if (crop.size < 3) {
            return true;
        } else {
            return false;
        }
    }

     public boolean canBeHarvested(TECrop crop) {
        return crop.size == 3;
    }

    public ItemStack getGain(TECrop crop) {
        return new ItemStack(Block.cactus , mod_ForTheTrees.random.nextInt(4) + 1);
    }

    public byte getSizeAfterHarvest(TECrop crop) {
        return 1;
    }

    public int growthDuration(TECrop crop) {
        return 600;
    }

    public String getTextureFile() {
        return "/ftt_crops.png";
    }
}
