package net.minecraft.src;

import net.minecraft.src.*;
import net.minecraft.src.ic2.api.CropCard;
import net.minecraft.src.ic2.api.TECrop;

public class FlaxCrop extends CropCard{

    public FlaxCrop() {
    }

    public String name() {
        return "Flax";
    }

    public String discoveredBy() {
        return "Eloraam";
    }

    public int tier() {
        return 2;
    }

    public int stat(int n) {
        switch(n) {
        case 0:
            return 3;

        case 1:
            return 0;

        case 2:
            return 0;

        case 3:
            return 3;

        case 4:
            return 0;
            
        default:
        	return 0;
        }
    }

    public String[] attributes() {
        return (new String[] {
            "Flower", "String"
        });
    }

    public int getSpriteIndex(TECrop crop) {
    	return crop.size + 18;
	}

    public boolean canGrow(TECrop crop) {
        if (crop.size < 4)
        	return true;
        return false;
    }

    public int weightInfluences(TECrop crop, float hum, float nut, float air) {
    	return (int)(1.1 * hum + 0.9 * nut + air);
    }
    
     public boolean canBeHarvested(TECrop crop) {
        return crop.size == 4;
    }

    public ItemStack getGain(TECrop crop) {
        return new ItemStack(Item.silk , mod_ForTheTrees.random.nextInt(2) + 3);
    }

    public byte getSizeAfterHarvest(TECrop crop) {
        return 2;
    }

    public int growthDuration(TECrop crop) {
        return 400;
    }

    public String getTextureFile() {
        return "/ftt_crops.png";
    }
    
}
