package net.minecraft.src;

import net.minecraft.src.*;
import net.minecraft.src.ic2.api.CropCard;
import net.minecraft.src.ic2.api.TECrop;

public class TorchweedCrop extends CropCard{

    public TorchweedCrop() {
    }

    public String name() {
        return "Torchweed";
    }

    public String discoveredBy() {
        return "Jack Harkness";
    }

    public int tier() {
        return 4;
    }

    public int stat(int n) {
        switch(n) {
        case 0:
            return 3;

        case 1:
            return 0;

        case 2:
            return 0;

        case 3:
            return 3;

        case 4:
            return 0;
            
        default:
        	return 0;
        }
    }

    public String[] attributes() {
        return (new String[] {
            "Stick", "Light", "Fire"
        });
    }

    public int getSpriteIndex(TECrop crop) {
    	if(crop.size < 4)
    		return (int)crop.size - 1;
    	else
    		return 18;
        }

    public boolean canGrow(TECrop crop) {
        if (crop.size < 4)
        	return true;
        
        return false;
    }

    public int weightInfluences(TECrop crop, float hum, float nut, float air) {
    	return (int)((hum + nut + air) * crop.getLightLevel() / 10);
    }
    
     public boolean canBeHarvested(TECrop crop) {
        return crop.size == 4;
    }

    public ItemStack getGain(TECrop crop) {
        return new ItemStack(Block.torchWood, mod_ForTheTrees.random.nextInt(2) + 1);
    }

    public byte getSizeAfterHarvest(TECrop crop) {
        return 2;
    }

    public int growthDuration(TECrop crop) {
        return 800;
    }

    public String getTextureFile() {
        return "/ftt_crops.png";
    }
    
    public int getEmittedLight(TECrop crop)
    {
    	if(crop.size == 4)
    		return 14;
    	
        return 0;
    }
}
