package net.minecraft.src;

import net.minecraft.src.*;
import net.minecraft.src.ic2.api.*;

public class CropSoybeans extends CropCard {

    public CropSoybeans() {
    }

    public String name() {
        return "Soybeans";
    }

    public String discoveredBy() {
        return "FunnyMan3595";
    }

    public int tier() {
        return 3;
    }

    public int stat(int n) {
        switch(n) {
        case 0:
            return 3;

        case 1:
            return 4;

        case 2:
            return 0;

        case 3:
            return 0;

        case 4:
            return 0;
            
        default:
        	return 0;
        }
    }

    public String[] attributes() {
        return (new String[] {
            "Bean", "Food", "Helpful"
        });
    }

    public int getSpriteIndex(TECrop crop)
    {
    	return crop.size + 27;
    }
    
    public void tick(TECrop crop)
    {
    	if(crop.nutrientStorage < 100)
    	{
    		crop.nutrientStorage += 2;

    		int x = crop.xCoord;
    		int y = crop.yCoord;
    		int z = crop.zCoord;
    		World world = crop.worldObj;
    		TileEntity tile;
    	
    		tile = world.getBlockTileEntity(x + 1, y, z);
    		if(tile instanceof TECrop)
    		{
    			if(((TECrop) tile).nutrientStorage < 100)
    			{
    				((TECrop) tile).nutrientStorage++;
    			}
    		}
    	
    		tile = world.getBlockTileEntity(x - 1, y, z);
    		if(tile instanceof TECrop)
    		{
    			if(((TECrop) tile).nutrientStorage < 100)
    			{
    				((TECrop) tile).nutrientStorage++;
    			}
    		}
    	
    		tile = world.getBlockTileEntity(x, y, z + 1);
    		if(tile instanceof TECrop)
    		{
    			if(((TECrop) tile).nutrientStorage < 100)
    			{
    				((TECrop) tile).nutrientStorage++;
    			}
    		}

    		tile = world.getBlockTileEntity(1, y, z - 1);
    		if(tile instanceof TECrop)
    		{
    			if(((TECrop) tile).nutrientStorage < 100)
    			{
    				((TECrop) tile).nutrientStorage++;
    			}
    		}
    	}
    }

    public boolean canGrow(TECrop crop) {
        if (crop.size < 5)
        	return true;
        return crop.size == 5 && crop.nutrientStorage >= 100;
    }

     public boolean canBeHarvested(TECrop crop) {
        return crop.size == 6;
    }

    public ItemStack getGain(TECrop crop) {
        return new ItemStack(mod_ForTheTrees.soyBeans, mod_ForTheTrees.random.nextInt(2) + 1);
    }

    public byte getSizeAfterHarvest(TECrop crop) {
        return 4;
    }

    public int growthDuration(TECrop crop) {
        return 600;
    }

    public String getTextureFile() {
        return "/ftt_crops.png";
    }
}
