package net.minecraft.src;

import java.io.File;
import java.util.Random;

//import cpw.mods.fml.common.FMLCommonHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.src.ic2.api.*;
import net.minecraft.src.forge.*;
import net.minecraft.src.*;



public class mod_ForTheTrees extends NetworkMod {
		public static Configuration config = new Configuration(new File(Minecraft.getMinecraftDir(), "config/ForTheTrees.cfg"));
//Server		public static Configuration config = new Configuration(new File(FMLCommonHandler.instance().getMinecraftRootDirectory(), "config/ForTheTrees.cfg"));
		public final static Random random = new Random( 1492 );
		public final int testMode;
		public final int cropid_apple;
		public final int cropid_bamboo;
		public final int cropid_bshroom;
		public final int cropid_bushwood;
		public final int cropid_cactus;
		public final int cropid_plankton;
		public final int cropid_rshroom;
		public final int cropid_torchweed;
		public final int cropid_flax;
		public final int cropid_corpse;
		public final int cropid_poisonivy;
		public final int cropid_soy;		
		public final int item_charbriq;
		public final int block_charbrick;
		public final int item_prune;
		public final int item_Eprune;
		public final int item_soybeans;
		public final int item_ivy;
		public final int item_TVP;
		public final int id_flaxseed;
		public static Item charcoalBriquette;
		public static Item pruningShears;
		public static Item ePruningShears;
		public static Item soyBeans;
		public static Item poisonIvy;
		public static Item TVPmeal;
		public static Block charcoalBrick;
		

		public mod_ForTheTrees() {
			config.load();
			
			testMode = Integer.parseInt(config.getOrCreateIntProperty("testmode", config.CATEGORY_GENERAL, 0).value);
			
			cropid_apple = Integer.parseInt(config.getOrCreateIntProperty("cropid.applebush", config.CATEGORY_GENERAL, 117).value);
			cropid_bamboo = Integer.parseInt(config.getOrCreateIntProperty("cropid.bamboo", config.CATEGORY_GENERAL, 118).value);
			cropid_bshroom = Integer.parseInt(config.getOrCreateIntProperty("cropid.brownshroom", config.CATEGORY_GENERAL, 119).value);
			cropid_bushwood = Integer.parseInt(config.getOrCreateIntProperty("cropid.bushwood", config.CATEGORY_GENERAL, 120).value);
			cropid_cactus = Integer.parseInt(config.getOrCreateIntProperty("cropid.cactus", config.CATEGORY_GENERAL, 121).value);
			cropid_plankton = Integer.parseInt(config.getOrCreateIntProperty("cropid.plankton", config.CATEGORY_GENERAL, 122).value);
			cropid_rshroom = Integer.parseInt(config.getOrCreateIntProperty("cropid.redshroom", config.CATEGORY_GENERAL, 123).value);
			cropid_torchweed = Integer.parseInt(config.getOrCreateIntProperty("cropid.torchweed", config.CATEGORY_GENERAL, 124).value);
			cropid_flax = Integer.parseInt(config.getOrCreateIntProperty("cropid.flax", config.CATEGORY_GENERAL, 125).value);
			cropid_corpse = Integer.parseInt(config.getOrCreateIntProperty("cropid.corpseweed", config.CATEGORY_GENERAL, 126).value);
			cropid_poisonivy = Integer.parseInt(config.getOrCreateIntProperty("cropid.poisonivy", config.CATEGORY_GENERAL, 127).value);
			cropid_soy = Integer.parseInt(config.getOrCreateIntProperty("cropid.soybeans", config.CATEGORY_GENERAL, 128).value);
			
			block_charbrick = Integer.parseInt(config.getOrCreateIntProperty("blockid.charcoalbrick", config.CATEGORY_BLOCK, 195).value);
			item_charbriq = Integer.parseInt(config.getOrCreateIntProperty("itemid.charcoalbriquette", config.CATEGORY_ITEM, 12300).value);
			item_prune = Integer.parseInt(config.getOrCreateIntProperty("itemid.pruningshears", config.CATEGORY_ITEM, 12301).value);
			item_Eprune = Integer.parseInt(config.getOrCreateIntProperty("itemid.Epruningshears", config.CATEGORY_ITEM, 12302).value);
			item_soybeans = Integer.parseInt(config.getOrCreateIntProperty("itemid.soybeans", config.CATEGORY_ITEM, 12303).value);
			item_ivy = Integer.parseInt(config.getOrCreateIntProperty("itemid.ivy", config.CATEGORY_ITEM, 12304).value);
			item_TVP = Integer.parseInt(config.getOrCreateIntProperty("itemid.TVP", config.CATEGORY_ITEM, 12305).value);
			
			id_flaxseed = Integer.parseInt(config.getOrCreateIntProperty("itemid.RP2flaxseed", config.CATEGORY_ITEM, 0).value);
			
			config.save();
		}
		
		@Override
        public boolean clientSideRequired()
        {
                return true;
        }

        @Override
        public boolean serverSideRequired()
        {
                return false;
        }
        
		@Override	
		public String getVersion() {
			return "v0.3";
		}
	
		@Override
		public String getPriorities() {
			return "required-after:mod_IC2";
		}

		@Override
		public void load() {
			charcoalBriquette = new ItemCharcoalBriquette(item_charbriq).setIconIndex(0).setItemName("charcoalBriquette");
			pruningShears = new ItemToolPrune(item_prune).setIconIndex(2).setItemName("pruningShears");
			ePruningShears = new ItemToolEPrune(item_Eprune).setIconIndex(3).setItemName("ePruningShears");
			soyBeans = new ItemSoybeans(item_soybeans).setIconIndex(8).setItemName("soyBeans");
			poisonIvy = new ItemPoisonivy(item_ivy).setIconIndex(12).setItemName("poisonIvy");
			TVPmeal = new ItemTVPmeal(item_TVP).setIconIndex(13).setItemName("TVPmeal");
			charcoalBrick = new BlockCharcoalBrick(block_charbrick, 1).setBlockName("charcoalBrick");
			
			CropCard.registerCrop(new CropApplebush(), cropid_apple);
			CropCard.registerCrop(new CropBamboo(), cropid_bamboo);
			CropCard.registerCrop(new CropBrownShroom(), cropid_bshroom);
			CropCard.registerCrop(new CropBushwood(), cropid_bushwood);
			CropCard.registerCrop(new CropCactus(), cropid_cactus);
			CropCard.registerCrop(new CropPlankton(), cropid_plankton);
			CropCard.registerCrop(new CropRedShroom(), cropid_rshroom);
			CropCard.registerCrop(new CropTorchweed(), cropid_torchweed);
			CropCard.registerCrop(new CropFlax(), cropid_flax);
			CropCard.registerCrop(new CropCorpseweed(), cropid_corpse);
			CropCard.registerCrop(new CropPoisonivy(), cropid_poisonivy);
			CropCard.registerCrop(new CropSoybeans(), cropid_soy);
			
			CropCard.registerBaseSeed(new ItemStack(Block.mushroomBrown.blockID , 1, -1), cropid_bshroom, 1, 1, 1, 1);
			CropCard.registerBaseSeed(new ItemStack(Block.mushroomRed.blockID, 1, -1), cropid_rshroom, 1, 1, 1, 1);
			CropCard.registerBaseSeed(new ItemStack(Block.cactus.blockID, 1, -1), cropid_cactus, 1, 1, 1, 1);
			CropCard.registerBaseSeed(new ItemStack(soyBeans.shiftedIndex, 1, -1), cropid_soy, 1, 1, 1, 1);
			CropCard.registerBaseSeed(new ItemStack(poisonIvy.shiftedIndex, 1, -1), cropid_poisonivy, 1, 1, 1, 10);
			

			if(id_flaxseed > 0)
				CropCard.registerBaseSeed(new ItemStack(id_flaxseed + 256, 1, -1), cropid_flax, 1, 1, 5, 1);

			
			if(testMode == 1) {
				CropCard.registerBaseSeed(new ItemStack(Item.appleRed.shiftedIndex, 1, -1), cropid_apple, 1, 1, 1, 1);
				CropCard.registerBaseSeed(new ItemStack(Block.sapling.blockID, 1, -1), cropid_bamboo, 1, 1, 1, 1);
				CropCard.registerBaseSeed(new ItemStack(Block.wood.blockID, 1, -1), cropid_bushwood, 1, 1, 1, 1);
				CropCard.registerBaseSeed(new ItemStack(Block.planks.blockID, 1, -1), cropid_plankton, 1, 1, 1, 1);
				CropCard.registerBaseSeed(new ItemStack(Block.torchWood, 1, -1), cropid_torchweed, 1, 1, 1, 1);
				CropCard.registerBaseSeed(new ItemStack(Item.bone.shiftedIndex , 1, -1), cropid_corpse, 1, 1, 1, 1);
				CropCard.registerBaseSeed(new ItemStack(Block.vine, 1, -1), cropid_poisonivy, 1, 1, 1, 10);
			}
			
			ModLoader.registerBlock(charcoalBrick);
			MinecraftForge.setBlockHarvestLevel(charcoalBrick, "pickaxe", 0);
			
			ForgeHooks.addGrassSeed(soyBeans.shiftedIndex, 0, 1, 10);
			
			Ic2Recipes.addCompressorRecipe(new ItemStack(Item.coal, 1, 1), new ItemStack(charcoalBriquette, 1));
			Ic2Recipes.addExtractorRecipe(new ItemStack(poisonIvy, 1), new ItemStack(Items.getItem("grinPowder").getItem(), 1));
			Ic2Recipes.addMaceratorRecipe(new ItemStack(soyBeans, 1), new ItemStack(TVPmeal, 1));
			Ic2Recipes.addCraftingRecipe(new ItemStack(charcoalBrick, 1), new Object[] {"BBB", "BSB", "BBB", 'B', charcoalBriquette, 'S', Item.slimeBall});
			Ic2Recipes.addCraftingRecipe(new ItemStack(charcoalBrick, 1), new Object[] {"BBB", "BRB", "BBB", 'B', charcoalBriquette, 'R', Items.getItem("resin") });
			Ic2Recipes.addCraftingRecipe(new ItemStack(Item.bucketMilk, 1), new Object[] {"SSS", "SBS", "SSS", 'S', soyBeans, 'B', Item.bucketEmpty});
			Ic2Recipes.addCraftingRecipe(new ItemStack(pruningShears, 1), new Object[] {" I ", "S S", 'I', Items.getItem("refinedIronIngot"), 'S', Item.stick});
			Ic2Recipes.addCraftingRecipe(new ItemStack(ePruningShears, 1), new Object[] {"P", "C", "B", 'P', pruningShears, 'C', Items.getItem("electronicCircuit"), 'B', Items.getItem("reBattery")});
			Ic2Recipes.addCraftingRecipe(new ItemStack(Item.beefRaw, 1), new Object[] {"MMM", "   ", "MMM", 'M', TVPmeal});
			Ic2Recipes.addCraftingRecipe(new ItemStack(Item.porkRaw, 1), new Object[] {"M M", "M M", "M M", 'M', TVPmeal});
			Ic2Recipes.addCraftingRecipe(new ItemStack(Item.fishRaw, 1), new Object[] {"M M", "   ", "M M", 'M', TVPmeal});
			Ic2Recipes.addCraftingRecipe(new ItemStack(Item.chickenRaw, 1), new Object[] {" M ", "M M", " M ", 'M', TVPmeal});
			Ic2Recipes.addCraftingRecipe(new ItemStack(Items.getItem("bioCell").getItem(), 1), new Object[] {"SSS", "SCS", "SSS", 'S', soyBeans, 'C', Items.getItem("cell")});
			

			ModLoader.addName(charcoalBriquette, "Charcoal Briquette");
			ModLoader.addName(charcoalBrick, "Charcoal Brick");
			ModLoader.addName(pruningShears, "Pruning Shears");
			ModLoader.addName(ePruningShears, "Electric Pruning Shears");
			ModLoader.addName(soyBeans, "Soybeans");
			ModLoader.addName(poisonIvy, "Poison Ivy");
			ModLoader.addName(TVPmeal, "Textured Vegetable Protein");
			

			MinecraftForgeClient.preloadTexture("/ftt_crops.png");
			MinecraftForgeClient.preloadTexture("/ftt_blocks.png");
		}
		
		@Override
		public int addFuel(int id, int var2)
		{
			if(id == charcoalBriquette.shiftedIndex)
				return 2000;
			
			if(id == charcoalBrick.blockID)
				return 16000;
			
			return 0;
		}
}