package net.minecraft.src;

import net.minecraft.src.ic2.api.*;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;


public class ItemToolEPrune extends ItemToolPrune implements IElectricItem
{
	public ItemToolEPrune(int i)
	{
		super(i);
		this.setMaxDamage(27);
	}
	
	public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int X, int Y, int Z, int side) 
	{
		if(ElectricItem.canUse(stack, 1000))
			if(ElectricItem.use(stack,  1000, player))
				return super.onItemUseFirst(stack, player, world, X, Y, Z, side);
		
		return false;
	}
	@Override
	public boolean canProvideEnergy()
	{
		return false;
	}

	@Override
	public int getChargedItemId()
	{
		return this.shiftedIndex;
	}

	@Override
	public int getEmptyItemId() {
		return this.shiftedIndex;
	}

	@Override
	public int getMaxCharge() {
		return 10000;
	}

	@Override
	public int getTier() {
		return 1;
	}

	@Override
	public int getTransferLimit() {
		return 200;
	}
	
    public String getTextureFile()
    {
            return "/ftt_blocks.png";
    }	
}