package net.minecraft.src;

import net.minecraft.src.*;
import net.minecraft.src.ic2.api.*;

public class CropCorpseweed extends CropCard {

    public CropCorpseweed() {
    }

    public String name() {
        return "Corpseweed";
    }

    public String discoveredBy() {
        return "Nekowulf";
    }

    public int tier() {
        return 5;
    }

    public int stat(int n) {
        switch(n) {
        case 0:
            return 3;

        case 1:
            return 0;

        case 2:
            return 0;

        case 3:
            return 3;

        case 4:
            return 0;
            
        default:
        	return 0;
        }
    }

    public String[] attributes() {
        return (new String[] {
            "Bone", "White", "Creepy"
        });
    }

    public int getSpriteIndex(TECrop crop) {
    	return (int)crop.size + 19;
        }

    public void tick(TECrop crop)
    {
    	if(crop.size < 4 && crop.nutrientStorage < 100)
    	{
    		int x = crop.xCoord;
    		int y = crop.yCoord;
    		int z = crop.zCoord;
    		int theft = 0;
    		World world = crop.worldObj;
    		TileEntity tile;
    	
    		tile = world.getBlockTileEntity(x + 1, y, z);
    		if(tile instanceof TECrop)
    		{
    			if(((TECrop) tile).nutrientStorage > 10)
    			{
    				((TECrop) tile).nutrientStorage--;
    				theft++;
    			}
    		}
    	
    		tile = world.getBlockTileEntity(x - 1, y, z);
    		if(tile instanceof TECrop)
    		{
    			if(((TECrop) tile).nutrientStorage > 10)
    			{
    				((TECrop) tile).nutrientStorage--;
    				theft++;
    			}
    		}
    	
    		tile = world.getBlockTileEntity(x, y, z + 1);
    		if(tile instanceof TECrop)
    		{
    			if(((TECrop) tile).nutrientStorage > 10)
    			{
    				((TECrop) tile).nutrientStorage--;
    				theft++;
    			}
    		}

    		tile = world.getBlockTileEntity(1, y, z - 1);
    		if(tile instanceof TECrop)
    		{
    			if(((TECrop) tile).nutrientStorage > 10)
    			{
    				((TECrop) tile).nutrientStorage--;
    				theft++;
    			}
    		}
    
   			crop.nutrientStorage += theft;
    	}
    }

    public boolean canGrow(TECrop crop)
    {
        if(crop.size < 3)
            return true;
        if(crop.size == 3 && crop.nutrientStorage > 75)
        	return true;
        
        return false;
    }

    public int weightInfluences(TECrop crop, float hum, float nut, float air) {
    	return (int)(air + hum + 4 * nut) / 2;
    }

     public boolean canBeHarvested(TECrop crop) {
        return crop.size >= 3;
    }

    public ItemStack getGain(TECrop crop) {
    	crop.nutrientStorage -= 50;
    	
    	if(crop.size == 4)
    		return new ItemStack(Item.bone,  mod_ForTheTrees.random.nextInt(2) + 1);

        return new ItemStack(Item.dyePowder, mod_ForTheTrees.random.nextInt(4) + 1, 15);
    }

    public byte getSizeAfterHarvest(TECrop crop) {
        return 1;
    }

    public int growthDuration(TECrop crop) {
        return 1000;
    }

    public String getTextureFile() {
        return "/ftt_crops.png";
    }
}
