package net.minecraft.src;

import net.minecraft.src.*;
import net.minecraft.src.forge.*;
import net.minecraft.src.ic2.api.*;

public class ItemToolPrune extends Item implements ITextureProvider
{
	public ItemToolPrune(int i)
	{
		super(i);
		this.setMaxStackSize(1);
		this.setMaxDamage(64);
	}

	public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int X, int Y, int Z, int side) 
    {
		if(world.getBlockTileEntity(X, Y, Z) instanceof TECrop)
		{
			TECrop crop = (TECrop)world.getBlockTileEntity(X, Y, Z);
			
			if(crop.id > 0)
			{
				if(CropCard.getCrop(crop.id).canBeHarvested(crop))
				{
					stack.damageItem(1, player);
					crop.size = 1;
					ItemStack drop = crop.generateSeeds(crop.id, crop.statGrowth, crop.statGain, crop.statResistance, crop.scanLevel);
					if(player.inventory.addItemStackToInventory(drop))
						return true;
				
					EntityItem entityDrop = new EntityItem(world, X, Y + 1, Z, drop);
					entityDrop.delayBeforeCanPickup = 10;
					return world.spawnEntityInWorld(entityDrop);
				}
			}
		}
		return false;
    }
	
	public boolean isFull3D()
    {
        return true;
    }

	public String getTextureFile()
    {
            return "/ftt_blocks.png";
    }
}