package net.minecraft.src;

import net.minecraft.src.*;
import net.minecraft.src.ic2.api.CropCard;
import net.minecraft.src.ic2.api.TECrop;

public class CropApplebush extends CropCard {

    public CropApplebush() {
    }

    public String name() {
        return "Apple Bush";
    }

    public String discoveredBy() {
        return "I Don't Now";
    }

    public int tier() {
        return 5;
    }

    public int stat(int n) {
        switch(n) {
        case 0:
            return 0;

        case 1:
            return 4;

        case 2:
            return 0;

        case 3:
            return 3;

        case 4:
            return 0;
            
        default:
        	return 0;
        }
    }

    public String[] attributes() {
        return (new String[] {
            "Apple", "Food", "Red"
        });
    }

    public int getSpriteIndex(TECrop crop) {
    	switch(crop.size) {
    	case 1:
    		return 4;
    		
    	case 2:
    		return 5;
    		
    	case 3:
    		return 7;
    		
    	case 4:
    		return 8;
    		
    	default:
    		return 4;
    	}
        }

    public boolean canGrow(TECrop crop) {
        return crop.size < 4;
    }

     public boolean canBeHarvested(TECrop crop) {
        return crop.size == 4;
    }

    public ItemStack getGain(TECrop crop) {
        return new ItemStack(Item.appleRed, mod_ForTheTrees.random.nextInt(2) + 1);
    }

    public byte getSizeAfterHarvest(TECrop crop) {
        return 2;
    }

    public int growthDuration(TECrop crop) {
        return 500;
    }

    public String getTextureFile() {
        return "/ftt_crops.png";
    }
}
