package net.minecraft.src;

import net.minecraft.src.*;
import net.minecraft.src.ic2.api.CropCard;
import net.minecraft.src.ic2.api.TECrop;

public class CropBrownShroom extends CropCard {

    public CropBrownShroom() {
    }

    public String name() {
        return "Brown Mushroom";
    }

    public String discoveredBy() {
        return "Notch";
    }

    public int tier() {
        return 2;
    }

    public int stat(int n) {
        switch(n) {
        case 0:
            return 0;

        case 1:
            return 4;

        case 2:
            return 0;

        case 3:
            return 3;

        case 4:
            return 0;
            
        default:
        	return 0;
        }
    }

    public String[] attributes() {
        return (new String[] {
            "Mushroom", "Food", "Brown"
        });
    }

    public int getSpriteIndex(TECrop crop) {
    	return crop.size < 3 ? (int)crop.size + 8 : 12;
        }

    public boolean canGrow(TECrop crop) {
        return crop.size < 3;
    }

    public int weightInfluences(TECrop crop, float hum, float nut, float air) {
    	return (int)((5 * hum + 10 * nut) / crop.getLightLevel());
    }

     public boolean canBeHarvested(TECrop crop) {
        return crop.size == 3;
    }

    public ItemStack getGain(TECrop crop) {
        return new ItemStack(Block.mushroomBrown, mod_ForTheTrees.random.nextInt(2) + 1);
    }

    public byte getSizeAfterHarvest(TECrop crop) {
        return 2;
    }

    public int growthDuration(TECrop crop) {
        return 400;
    }

    public String getTextureFile() {
        return "/ftt_crops.png";
    }
}
