package net.minecraft.src;

import net.minecraft.src.*;
import net.minecraft.src.ic2.api.CropCard;
import net.minecraft.src.ic2.api.TECrop;

public class CropPoisonivy extends CropCard {

    public CropPoisonivy() {
    }

    public String name() {
        return "Poison Ivy";
    }

    public String discoveredBy() {
        return "I Don't Now";
    }

    public int tier() {
        return 4;
    }

    public int stat(int n) {
        switch(n) {
        case 0:
            return 3;

        case 1:
            return 0;

        case 2:
            return 4;

        case 3:
            return 3;

        case 4:
            return 1;
            
        default:
        	return 0;
        }
    }

    public String[] attributes() {
        return (new String[] {
            "Vine", "Poison", "Leaves"
        });
    }

    public int getSpriteIndex(TECrop crop) {
    	return (int)crop.size + 23;
        }

    public boolean canGrow(TECrop crop) {
        return crop.size < 4;
    }

     public boolean canBeHarvested(TECrop crop) {
        return crop.size == 4;
    }

    public ItemStack getGain(TECrop crop)
    {
    	if(crop.statResistance < 10)
    		crop.statResistance = 10;
    	if(crop.statResistance < 40)
    		if(crop.statResistance < crop.statGrowth * 2 || mod_ForTheTrees.random.nextInt(10) == 0)
    			crop.statResistance++;

        return new ItemStack(mod_ForTheTrees.poisonIvy, mod_ForTheTrees.random.nextInt(2) + 1);
    }

    public byte getSizeAfterHarvest(TECrop crop) {
        return 1;
    }

    public int growthDuration(TECrop crop) {
        return 800;
    }

    public boolean onEntityCollision(TECrop crop, Entity thing)
    {
        if (crop.size > 2 && thing instanceof EntityLiving)
        {
        	((EntityLiving)thing).addPotionEffect(new PotionEffect(19, (mod_ForTheTrees.random.nextInt(10) + 5) * 20, 0));
        }

        return super.onEntityCollision(crop, thing);
    }

    public String getTextureFile() {
        return "/ftt_crops.png";
    }
}
