package net.minecraft.src;

import java.io.File;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.IOException;

import net.minecraft.client.Minecraft;
// --SERVER COMPILATION NOTE--
// comment above line out if compiling for the server
import net.minecraft.src.forge.*;
import net.minecraft.src.ic2.api.*;

// due to some major omissions on Forge's part
// (there is no way to get the Minecraft directory on both the client and the server)
// this code needs separate versions for client and server
// however, it's a change of 2 lines, so I'm not going to distribute two different files
// it requires both Forge and the IC2 API

public class mod_UUMarbleRecipe extends NetworkMod
{
  
  public static int RP2StoneBlockID = 98;
  // fired stone bricks, by default
  public static int RP2OreBlockID = 35;
  // wool, by default
  public static int RP2ResourcesItemID = 95;
  // dye has default ID of 351, so that's an item ID of 95
  // this is just so that it won't give nonsensical results
  private boolean has_RP2_config_file = false;
  private boolean found_RP2_stone = false;
  // marble, basalt
  // stone.id, damage values of 0 and 1
  private boolean found_RP2_ores = false;
  // tungsten, silver
  // ores.id, damage values of 6 and 3
  private boolean found_RP2_resources = false;
  // resource.id, damage value 0, 1, 2, 6
  // we give these as items, not blocks
  // also note that you need to add on 256 here to get the item ID
  // it's listed as 1001 in the config file
  // so you'll also need to check whether we're using 4096 blocks here
  // add Block.blocksList.length to the value here
  
  
  public String getVersion()
  {
    return "1.1";
  }
  
  
  public String getPriorities()
  {
    return "after:mod_IC2;after:mod_RedPowerWorld;after:RedPowerWorld";
  }
  
  // --SERVER COMPILATION NOTE--
  // comment out the first File declaration line
  // and uncomment the second.
  
  static File RP2Config = new File(Minecraft.getMinecraftDir(), "redpower/redpower.cfg");
  // client's file location
  
  // static File RP2Config = new File("./redpower/redpower.cfg");
  // server's config file location
  
  
  public void SetBlockID()
  {
    if(!RP2Config.exists())
    {
      return;
    }
    has_RP2_config_file = true;
    
    // ok, we need to do this the hard way
    // load RP2's config file and look for the block ID
    // then we can feed it to the recipe maker
    
    // the block ID is stored in the "world" scope in RP2's config file
    // under an entry called stone.id
    
    
    // so, copying out the important bits of Forge's Configuration.java...
    
    BufferedReader buffer = null;
    
    int linecount = 1;
    
    try
    {
      if(RP2Config.canRead())
      {
	FileInputStream fileinputstream = new FileInputStream(RP2Config);
	buffer = new BufferedReader(new InputStreamReader(fileinputstream, "8859_1"));
	
	String line;
	while(true)
	{
	  line = buffer.readLine();
	  if(line == null)
	  {
	    break;
	  }
	  int valStart = -1, valEnd = -1;
	  boolean skip = false;
	  
	  if(line.contains("stone.id"))
	  {
	    found_RP2_stone = true;
	    
	    for(int i = 0; i < line.length() && !skip; i++)
	    {
	      if (Character.isDigit(line.charAt(i)))
	      {
		  if (valStart == -1)
		  {
		      valStart = i;
		      System.out.println("Found RP2 stone block ID on line " + Integer.toString(linecount) + ", column " + Integer.toString(valStart));
		  }

		  valEnd = i;
	      }
	      else
	      {
		continue;
	      }
	    }
	    
	    RP2StoneBlockID = Integer.parseInt(line.substring(valStart));
	    continue;
	  }
	  
	  if(line.contains("ores.id"))
	  { 
	    found_RP2_ores = true;
	    
	    for(int i = 0; i < line.length() && !skip; i++)
	    {
	      if (Character.isDigit(line.charAt(i)))
	      {
		  if (valStart == -1)
		  {
		      valStart = i;
		      System.out.println("Found RP2 ores block ID on line " + Integer.toString(linecount) + ", column " + Integer.toString(valStart));
		  }

		  valEnd = i;
	      }
	      else
	      {
		continue;
	      }
	    }
	    
	    RP2OreBlockID = Integer.parseInt(line.substring(valStart));
	    continue;
	  }
	  
	  if(line.contains("resource.id"))
	  { 
	    found_RP2_resources = true;
	    
	    for(int i = 0; i < line.length() && !skip; i++)
	    {
	      if (Character.isDigit(line.charAt(i)))
	      {
		  if (valStart == -1)
		  {
		      valStart = i;
		      System.out.println("Found RP2 resources item ID on line " + Integer.toString(linecount) + ", column " + Integer.toString(valStart));
		  }

		  valEnd = i;
	      }
	      else
	      {
		continue;
	      }
	    }
	    
	    // RP2ResourcesItemID = Integer.parseInt(line.substring(valStart)) + Block.blocksList.length;
	    RP2ResourcesItemID = Integer.parseInt(line.substring(valStart)) + 256;
	    
	    // critical bug: though blocksList.length is indeed 4096
	    // items start at 256 here
	    // so we're going to hard-code this bit
	    continue;
	  }
	  
	  linecount++;
	}
      }
    }
    catch (IOException e)
    {
	e.printStackTrace();
    }
    
    // ok, let's see how many mistakes I made when copying out and altering the Forge code
    // two missing closing curly brackets
    // one incorrect assignment to null (which would have been an equality test, also un-necessary)
    // one missing declaration for the BufferedReader buffer
    // one failure to import java.io.IOException
    // one failure to include the try-catch exception pair
    // and it compiles
    // naturally, it fails to work
    // so we'll alter the parsing code
    
      // of course, we can't just feed the RP2 config file into the Forge config handler
      // nooo, that would just be wrong
      // can't have any of that nice standardised config file format here, can we...
      // we'll just have to read the damned file ourselves
  }
  
  public void load()
  {
   SetBlockID();
    
    // and it keeps giving me NPEs in ItemStack, line 42 when I try to reference blockStone here
    // this is line 37 in the deobfuscated code, which is where it calls the function on line 57
    // for whatever reason, it can't seem to access blockStone here
   

    
    // finally, it works
    // annoying that I can't just make a header file like I did for IC2
    // but I suppose the code's cleaner this way
    
   // System.out.println("blocksList.length = " + Integer.toString(Block.blocksList.length));
   
    if(!has_RP2_config_file)
    {
      System.out.println("Could not find RP2 config file, no recipes added.");
    }
    else
    {
      if(found_RP2_stone)
      {
	// marble metadata = 0, smooth basalt metadata = 1
	Ic2Recipes.addCraftingRecipe(new ItemStack(RP2StoneBlockID, 8, 0), new Object[] {"M  ", "   ", "   ", Character.valueOf('M'), Items.getItem("matter")});
	
	Ic2Recipes.addCraftingRecipe(new ItemStack(RP2StoneBlockID, 6, 1), new Object[] {"  M", "   ", "   ", Character.valueOf('M'), Items.getItem("matter")});
	
	System.out.println("Redpower Marble and Basalt UU matter recipes loaded.");
      }
      
      if(found_RP2_ores)
      {
	// silver metadata = 3, tungsten metadata = 6
	Ic2Recipes.addCraftingRecipe(new ItemStack(RP2OreBlockID, 1, 3), new Object[] {"  M", " MM", "  M", Character.valueOf('M'), Items.getItem("matter")});
	
	// Ic2Recipes.addCraftingRecipe(new ItemStack(RP2OreBlockID, 1, 6), new Object[] {"DTD", "D D", "DTD", Character.valueOf('D'), new ItemStack(Items.getItem("matter").itemID, 2, 0), Character.valueOf('T'), new ItemStack(Items.getItem("matter").itemID, 3, 0)});
	
	// Double, Triple counts of UU matter here
	// it doesn't seem to require multiple items/stack - it works with just one item only
	// let's put a diamond in the middle to make it more expensive...
	
	Ic2Recipes.addCraftingRecipe(new ItemStack(RP2OreBlockID, 1, 6), new Object[] {"MMM", "MDM", "MMM", Character.valueOf('M'), Items.getItem("matter"), Character.valueOf('D'), Item.diamond});
	
	System.out.println("Redpower Silver and Tungsten UU matter recipes loaded.");
      }
      
      if(found_RP2_resources)
      {
	// ruby, emerald, sapphire, nikolite metadata = 0, 1, 2, 6
	Ic2Recipes.addCraftingRecipe(new ItemStack(RP2ResourcesItemID, 1, 0), new Object[] {"M  ", "   ", "MMM", Character.valueOf('M'), Items.getItem("matter")});
	
	Ic2Recipes.addCraftingRecipe(new ItemStack(RP2ResourcesItemID, 1, 1), new Object[] {" M ", "   ", "MMM", Character.valueOf('M'), Items.getItem("matter")});
	
	Ic2Recipes.addCraftingRecipe(new ItemStack(RP2ResourcesItemID, 1, 2), new Object[] {"  M", "   ", "MMM", Character.valueOf('M'), Items.getItem("matter")});
	
	Ic2Recipes.addCraftingRecipe(new ItemStack(RP2ResourcesItemID, 12, 6), new Object[] {"MMM", " M ", "   ", Character.valueOf('M'), Items.getItem("matter")});
	
	System.out.println("Redpower Gems and Nikolite UU matter recipes loaded.");
      }
      
      if(!found_RP2_stone && !found_RP2_ores && !found_RP2_resources)
      {
	System.out.println("Found RP2 config file, but could not locate block/item IDs. No RP2 UU matter recipes loaded.");
      }
    }
  }
  
  public boolean clientSideRequired()
  {
    return false;
  }
  
  public boolean serverSideRequired()
  {
    return false;
  }
  
}
