package codechicken.nei.plugins.ic2_charge;

import java.util.List;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ic2.api.IElectricItem;

import codechicken.nei.IHandleTooltip;

public class ChargeTooltipHandler implements IHandleTooltip {

	public ChargeTooltipHandler() { }
	
	@Override
	public List<String> handleTooltip(ItemStack stack, List<String> currentTip) {
		if (stack != null && stack.hasTagCompound()) {
			Item q = stack.getItem();
			if (q instanceof IElectricItem) {
				int maxcharge = ((IElectricItem) q).getMaxCharge();
				int charge = stack.getTagCompound().getInteger("charge");
				currentTip.add(charge + "/" + maxcharge + " EU");
			}
		}
		return currentTip;
	}

}
