/*
 * Decompiled with CFR 0.152.
 */
package mcyu;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import mcyu.MCYUMD5;
import mcyu.MinecraftRefs;

public class MCYURunner {
    private StringBuilder work;
    public static final String NAME = "MCYU";
    public static final String VERSION = "r2";
    public static final String UPDATE = "2011/11/10";
    public static final String AUTHOR = "by Ha3 (http://goo.gl/Xx21e)";
    private final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final FileFilter ff_directory = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    private final FileFilter ff_notadirectory = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isDirectory();
        }
    };

    public String perform() {
        return this.perform(MinecraftRefs.getMinecraftDir());
    }

    public String perform(File override) {
        boolean meta_inf_fuckflag = false;
        this.init();
        this.printMarker("version");
        this.printVersion();
        this.printAuthor();
        this.printNewLine();
        this.printMarker("info");
        this.printDate();
        this.printCurrentTime();
        this.printOs();
        try {
            this.printJavaData();
        }
        catch (Exception e1) {
            this.printErrorJavaData();
        }
        this.printNewLine();
        this.printMarker("minecraftdir");
        if (override != null && override.exists()) {
            this.printWorkingDir(override);
            this.printDirRecursive(override, 0);
        } else {
            this.printErrorMinecraftDir();
        }
        this.printNewLine();
        this.printMarker("minecraftjar");
        try {
            Map<String, Long> jarContents = this.gatherMinecraftJar(override);
            this.printArchive(jarContents);
            if (jarContents.keySet().contains("META-INF/MANIFEST.MF") || jarContents.keySet().contains("META-INF/MOJANG_C.DSA") || jarContents.keySet().contains("META-INF/MOJANG_C.SF")) {
                meta_inf_fuckflag = true;
            }
        }
        catch (FileNotFoundException e) {
            this.printErrorMinecraftJarFile();
        }
        catch (ZipException e) {
            this.printErrorMinecraftJarZip();
        }
        this.printNewLine();
        this.printMarker("remarks");
        if (meta_inf_fuckflag) {
            this.printMetaInf();
        }
        this.printNewLine();
        this.printEndOfFileSafe();
        return this.work.toString();
    }

    private void printVersion() {
        this.line("MCYU r2 (2011/11/10)");
    }

    private void printAuthor() {
        this.line(AUTHOR);
    }

    private void printDate() {
        Calendar calendardate = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        String formalized = format.format(calendardate.getTime());
        this.append("DATE: ").line(formalized);
    }

    private void printCurrentTime() {
        Calendar calendardate = Calendar.getInstance();
        this.append("CTIME: ").line(calendardate.getTimeInMillis());
    }

    private void printOs() {
        this.append("OS: ").line(System.getProperty("os.name"));
        this.append("MCOS: ").line((Object)MinecraftRefs.getOs());
    }

    private void printJavaData() throws Exception {
        try {
            String jver = System.getProperty("java.version");
            String jven = System.getProperty("java.vendor");
            String jvvmname = System.getProperty("java.vm.name");
            String jvvminfo = System.getProperty("java.vm.info");
            String jvvmvend = System.getProperty("java.vm.vendor");
            this.append("JAVAVERSION: ").line(jver);
            this.append("JAVAVENDOR: ").line(jven);
            this.append("JAVAVMNAME: ").line(jvvmname);
            this.append("JAVAVMINFO: ").line(jvvminfo);
            this.append("JAVAVMVENDOR: ").line(jvvmvend);
        }
        catch (Throwable throwable) {
            throw new Exception();
        }
    }

    private void printMarker(String marker) {
        this.append("@").line(marker);
    }

    private void printEndOfFileSafe() {
        this.line("@EOF");
    }

    private void printNewLine() {
        this.line("");
    }

    private void printMetaInf() {
        this.line(": META-INF is not empty");
    }

    private void printErrorMinecraftDir() {
        this.line("!ERROR: Couldn't resolve Minecraft directory location");
    }

    private void printErrorJavaData() {
        this.line("!ERROR: Couldn't fetch Java VM Information");
    }

    private void printErrorMinecraftJarFile() {
        this.line("!ERROR: Couldn't find minecraft.jar");
    }

    private void printErrorMinecraftJarZip() {
        this.line("!ERROR: Couldn't process minecraft.jar contents (archive issue)");
    }

    private void printWorkingDir(File dir) {
        this.line(dir.getAbsolutePath());
    }

    private Map<String, Long> gatherMinecraftJar(File override) throws FileNotFoundException, ZipException {
        return this.gatherArchive(new File(override, "bin/minecraft.jar"));
    }

    private Map<String, Long> gatherArchive(File archive) throws FileNotFoundException, ZipException {
        Map<String, Long> synth = null;
        if (!archive.exists()) {
            throw new FileNotFoundException();
        }
        try {
            synth = MCYURunner.archiveToMap(archive);
        }
        catch (IOException e) {
            throw new ZipException();
        }
        return synth;
    }

    private void printArchive(Map<String, Long> jarContents) {
        for (Map.Entry<String, Long> elt : jarContents.entrySet()) {
            this.append(": ").line(elt.getKey());
        }
    }

    private void printDirRecursive(File dir, int deepness) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.blank(deepness * 2).append("+ ").line(dir.getName());
        File[] directories = dir.listFiles(this.ff_directory);
        File[] afiles = dir.listFiles(this.ff_notadirectory);
        List<File> directoriesAsList = Arrays.asList(directories);
        List<File> afilesAsList = Arrays.asList(afiles);
        Collections.sort(directoriesAsList);
        Collections.sort(afilesAsList);
        ArrayList<File> fileList = new ArrayList<File>(directoriesAsList);
        fileList.addAll(afilesAsList);
        for (File file : fileList) {
            if (file.isDirectory()) {
                this.printDirRecursive(file, deepness + 1);
                continue;
            }
            this.blank(deepness * 2 + 2).append("- ").append(file.getName());
            try {
                String checksum = MCYUMD5.getMD5Checksum(file);
                this.append("\t\t\t : ").line(checksum);
            }
            catch (Exception e) {
                this.line("");
            }
        }
    }

    private void init() {
        this.work = new StringBuilder();
    }

    private MCYURunner blank(int length) {
        if (length <= 0) {
            return this;
        }
        int i = 0;
        while (i < length) {
            this.work.append(" ");
            ++i;
        }
        return this;
    }

    private MCYURunner append(Object sentence) {
        this.work.append(sentence);
        return this;
    }

    private MCYURunner line(Object sentence) {
        this.append(sentence).append(this.LINE_SEPARATOR);
        return this;
    }

    private static Map<String, Long> archiveToMap(File file) throws FileNotFoundException, IOException {
        if (!file.isFile()) {
            throw new IllegalArgumentException();
        }
        TreeMap<String, Long> contents = new TreeMap<String, Long>();
        if (file.getName().endsWith(".jar") || file.getName().endsWith(".zip")) {
            boolean canProcess;
            FileInputStream fileinputstream = new FileInputStream(file);
            ZipInputStream zipinputstream = new ZipInputStream(fileinputstream);
            do {
                ZipEntry zipentry;
                boolean bl = canProcess = (zipentry = zipinputstream.getNextEntry()) != null;
                if (!canProcess) continue;
                String eltName = zipentry.getName();
                long eltCrc = zipentry.getCrc();
                contents.put(eltName, eltCrc);
            } while (canProcess);
            fileinputstream.close();
        }
        return contents;
    }
}

