/*
 * Decompiled with CFR 0.152.
 */
package mcyu;

import java.io.File;
import mcyu.EnumOS2;

public class MinecraftRefs {
    static File minecraftDir;

    public static File getMinecraftDir() {
        if (minecraftDir == null) {
            minecraftDir = MinecraftRefs.getAppDir("minecraft");
        }
        return minecraftDir;
    }

    public static File getAppDir(String s) {
        File file;
        String s1 = System.getProperty("user.home", ".");
        switch (MinecraftRefs.getOs()) {
            case linux: 
            case solaris: {
                file = new File(s1, '.' + s + '/');
                break;
            }
            case windows: {
                String s2 = System.getenv("APPDATA");
                if (s2 != null) {
                    file = new File(s2, "." + s + '/');
                    break;
                }
                file = new File(s1, '.' + s + '/');
                break;
            }
            case macos: {
                file = new File(s1, "Library/Application Support/" + s);
                break;
            }
            default: {
                file = new File(s1, s + '/');
            }
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + file);
        }
        return file;
    }

    public static EnumOS2 getOs() {
        String s = System.getProperty("os.name").toLowerCase();
        if (s.contains("win")) {
            return EnumOS2.windows;
        }
        if (s.contains("mac")) {
            return EnumOS2.macos;
        }
        if (s.contains("solaris")) {
            return EnumOS2.solaris;
        }
        if (s.contains("sunos")) {
            return EnumOS2.solaris;
        }
        if (s.contains("linux")) {
            return EnumOS2.linux;
        }
        if (s.contains("unix")) {
            return EnumOS2.linux;
        }
        return EnumOS2.unknown;
    }
}

