package mffs.projectors;

import immibis.core.Side;
import mffs.CoordinateList;

public class FFShapeExtender extends FFShape {
	
	private final short facing, ausrichtungx, ausrichtungy, ausrichtungz;
	private final int wide, length, distance;

	public FFShapeExtender(TileProjector tile,
			short facing, int wide, int length, int distance,
			short ausrichtungx, short ausrichtungy, short ausrichtungz) {
		super(tile);
		
		this.facing = facing;
		this.ausrichtungx = ausrichtungx;
		this.ausrichtungy = ausrichtungy;
		this.ausrichtungz = ausrichtungz;
		this.wide = wide;
		this.length = length;
		this.distance = distance;
	}

	@Override
	public void getFieldBlocks(CoordinateList list) {
		for (int x1 = 0; x1 <= wide; x1++) {
			int tempx = ausrichtungx * x1;
			int tempy = ausrichtungy * x1;
			int tempz = ausrichtungz * x1;

			for (int y1 = 1; y1 <= length; y1++) {
				
				switch(facing) {
				case Side.NY: tempy = -y1 - distance; break;
				case Side.PY: tempy = y1 + distance; break;
				case Side.NZ: tempz = -y1 - distance; break;
				case Side.PZ: tempz = y1 + distance; break;
				case Side.NX: tempx = -y1 - distance; break;
				case Side.PX: tempx = y1 + distance; break;
				}
				
				list.add(centX + tempx, centY + tempy, centZ + tempz, TileProjector.MODE_FIELD);
			}
		}
	}

	@Override
	public int getBlockMode(int x, int y, int z) {
		x -= centX; y -= centY; z -= centZ;
		
		int dist;
		
		switch(facing) {
		case Side.NX: dist = -x; x = 0; break;
		case Side.PX: dist = x;  x = 0; break;
		case Side.NY: dist = -y; y = 0; break;
		case Side.PY: dist = y;  y = 0; break;
		case Side.NZ: dist = -z; z = 0; break;
		case Side.PZ: dist = z;  z = 0; break;
		default: return 0;
		}
		
		if(dist < distance || dist > distance + length)
			return 0;
		
		int d = -1;
		if(d == -1 && ausrichtungx != 0) d = x/ausrichtungx;
		if(d == -1 && ausrichtungy != 0) d = x/ausrichtungy;
		if(d == -1 && ausrichtungz != 0) d = x/ausrichtungz;
		
		if(d < 0 || d > length) return 0;
		
		if(x * ausrichtungx != d) return 0;
		if(y * ausrichtungy != d) return 0;
		if(z * ausrichtungz != d) return 0;
		
		return TileProjector.MODE_FIELD;
	}

}
