package mffs;

import immibis.core.NonSharedProxy;
import immibis.core.Side;

import java.util.List;

import mffs.projectors.TileProjector;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Slot;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;

public class ItemMFD_offset extends ItemMFD {

	public ItemMFD_offset(int i) {
		super(i, 2);
		setIconIndex(5);
	}
	
	private int clamp(int i) {
		if(i < -TileProjector.maxOffset)
			return -TileProjector.maxOffset;
		if(i > TileProjector.maxOffset)
			return TileProjector.maxOffset;
		return i;
	}

	public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int x, int y, int z, int side) {
		TileEntity te = world.getBlockTileEntity(x, y, z);
		if(te instanceof TileProjector) {
			TileProjector p = (TileProjector)te;
			if(p.getActive()) {
				NonSharedProxy.sendChat(entityplayer, "Cannot move an active forcefield.");
				return true;
			}
			int step = entityplayer.isSneaking() ? -1 : 1;
			switch(side) {
			case Side.NX: p.offsetX = clamp(p.offsetX + step); break;
			case Side.NY: p.offsetY = clamp(p.offsetY + step); break;
			case Side.NZ: p.offsetZ = clamp(p.offsetZ + step); break;
			case Side.PX: p.offsetX = clamp(p.offsetX - step); break;
			case Side.PY: p.offsetY = clamp(p.offsetY - step); break;
			case Side.PZ: p.offsetZ = clamp(p.offsetZ - step); break;
			}
			NonSharedProxy.sendChat(entityplayer, "New field offset: "+p.offsetX+","+p.offsetY+","+p.offsetZ);
			return true;
		}
		return false;
	}
}
