package mffs;

/* $if jclient$ */

import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.TileEntity;
import immibis.core.api.porting.PortableBlockRenderer;
import immibis.core.aspects.ClientOnly;
/* $if mc >= 1.3$ */
import net.minecraftforge.client.ForgeHooksClient;
/* $else$
import net.minecraft.src.forge.MinecraftForgeClient;
$endif$ */

@ClientOnly
public class BlockRenderer implements PortableBlockRenderer {
	@Override
	public boolean renderWorldBlock(RenderBlocks rb, IBlockAccess w, int x, int y, int z, Block b, int model) {
		if(b == mod_ModularForceFieldSystem.MFFSFieldblock) {
			int meta = w.getBlockMetadata(x, y, z);
			
			boolean usingCamo = false;
			
			if(BlockForceField.isCamo(meta))
			{
				TileEntity te = w.getBlockTileEntity(x, y, z);
				if(te != null)
				{
					int camoBlock = ((TileCamouflagedField)te).camoBlockId;
					BlockForceField.useTextures = mod_ModularForceFieldSystem.idtotextur.get(camoBlock);
					usingCamo = (BlockForceField.useTextures != null);
					//System.out.println("camoblock "+camoBlock+", textures "+BlockForceField.useTextures);
				}
			}
			
			if(!usingCamo)
			{
				/* $if mc < 1.3$
				MinecraftForgeClient.bindTexture("/mffs_grafik/blocks.png");
				rb.renderStandardBlock(b, x, y, z);
				MinecraftForgeClient.unbindTexture();
				$else$ */
				ForgeHooksClient.bindTexture("/mffs_grafik/blocks.png", 0);
				rb.renderStandardBlock(b, x, y, z);
				ForgeHooksClient.unbindTexture();
				/* $endif$ */
			}
			else
			{
				rb.renderStandardBlock(b, x, y, z);
				BlockForceField.useTextures = null;
			}
			
			return true;
		}
		return false;
	}
	
	@Override
	public void renderInvBlock(RenderBlocks rb, Block b, int meta, int model) {
		// field blocks shouldn't be in inventories - let them be invisible
	}
}

/* $endif$ */