package mffs;

import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NetworkManager;
import net.minecraft.src.Packet;
import net.minecraft.src.Packet132TileEntityData;
import net.minecraft.src.TileEntity;

public class TileCamouflagedField extends TileEntity {
	public int camoBlockId = -1;
	
	//@Override // server-only override
	public Packet getDescriptionPacket() {
		Packet132TileEntityData p = new Packet132TileEntityData();
		p.isChunkDataPacket = true;
		p.xPosition = xCoord;
		p.yPosition = yCoord;
		p.zPosition = zCoord;
		p.actionType = camoBlockId;
		return p;
	}
	
	@Override
	public void onDataPacket(NetworkManager net, Packet132TileEntityData p) {
		camoBlockId = p.actionType;
	}
	
	@Override
	public void writeToNBT(NBTTagCompound nbt) {
		super.writeToNBT(nbt);
		nbt.setInteger("camo", camoBlockId);
	}
	
	@Override
	public void readFromNBT(NBTTagCompound nbt) {
		super.readFromNBT(nbt);
		camoBlockId = nbt.getInteger("camo");
	}
}
