package mffs;

/*
 *  Typ 1: Generator
 *  Typ 2: Projektor
 * 
 */

import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NetworkManager;
import net.minecraft.src.Packet;
import net.minecraft.src.Packet132TileEntityData;
import net.minecraft.src.TileEntity;

public class TileUpgradePassive extends TileEntityMaschines {

	private short connectet_typID;
	private int conectet_ID;
	private int counter;
	
	//@Override // server-only override
	public Packet getDescriptionPacket() {
		Packet132TileEntityData p = new Packet132TileEntityData();
		p.isChunkDataPacket = true;
		p.xPosition = xCoord;
		p.yPosition = yCoord;
		p.zPosition = zCoord;
		p.actionType = conectet_ID != 0 ? 1 : 0;
		return p;
	}
	
	@Override
	public void onDataPacket(NetworkManager net, Packet132TileEntityData p) {
		conectet_ID = p.actionType;
	}

	public TileUpgradePassive() {

		conectet_ID = 0;
		counter = 0;
		connectet_typID = 0;
	}

	public int getconectet_ID() {
		return conectet_ID;
	}

	public void setconectet_ID(int conectet_ID) {
		this.conectet_ID = conectet_ID;
		if((this.conectet_ID != 0) != (conectet_ID != 0))
			worldObj.markBlockNeedsUpdate(xCoord, yCoord, zCoord);
	}

	public short getConnectet_typID() {
		return connectet_typID;
	}

	public void setConnectet_typID(short i) {
		this.connectet_typID = i;
	}

	public void updateEntity() {

		if(!worldObj.isRemote) {

			if (getActive() && getWrenchDropRate() != -1.0F) {
				setWrenchRate(-1.0F);
			}
			if (!getActive() && getWrenchDropRate() != 1.0F) {
				setWrenchRate(1.0F);
			}
		}
	}

	public void updatecheck() {

		if(!worldObj.isRemote) {

			if (conectet_ID != 0) {
				switch (connectet_typID) {
				case 1:
					TileEntity Generator = Linkgrid.getWorldMap(worldObj).getGenerator().get(conectet_ID);
					if (Generator == null) {
						setconectet_ID(0);
						setActive(false);
						updateEntity();
					}
					break;
				case 2:
					TileEntity Projektor = Linkgrid.getWorldMap(worldObj).getProjektor().get(conectet_ID);
					if (Projektor == null) {
						setconectet_ID(0);
						setActive(false);
						updateEntity();
					}
					break;
				}

			}

		}
	}

	public void readFromNBT(NBTTagCompound nbttagcompound) {

		super.readFromNBT(nbttagcompound);

	}

	public void writeToNBT(NBTTagCompound nbttagcompound) {

		super.writeToNBT(nbttagcompound);

	}
}
