package mffs;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;

public class ItemIDCard extends Item {

	private StringBuffer info = new StringBuffer();

	public ItemIDCard(int i) {
		super(i);
		setIconIndex(18);
		setMaxStackSize(1);

	}

	public String getTextureFile() {
		return "/mffs_grafik/items.png";
	}

	public boolean isRepairable() {
		return false;
	}

	public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {

		if(!world.isRemote) {

			Functions.ChattoPlayer(entityplayer, ":-) Wait for Beta 6");
			Functions.ChattoPlayer(entityplayer, Functions.getTAGfromItemstack(itemstack).getString("name"));
		}

		return itemstack;

	}

}
