package mffs.projectors;

import immibis.core.Side;
import mffs.CoordinateList;

import static mffs.projectors.TileProjector.MODE_FIELD;

public class FFShapeDirectional extends FFShape {

	public FFShapeDirectional(TileProjector tile, short facing, int distance, int length) {
		super(tile);
		this.facing = facing;
		this.distance = distance;
		this.length = length;
	}
	
	private final short facing;
	private final int distance, length;
	
	@Override
	public void getFieldBlocks(CoordinateList list) {
		
		for(int k = 0; k <= length; k++) {
			switch(facing) {
			case Side.NY: list.add(centX, centY - distance - k, centZ, MODE_FIELD); break;
			case Side.PY: list.add(centX, centY + distance + k, centZ, MODE_FIELD); break;
			case Side.NZ: list.add(centX, centY, centZ - distance - k, MODE_FIELD); break;
			case Side.PZ: list.add(centX, centY, centZ + distance + k, MODE_FIELD); break;
			case Side.NX: list.add(centX - distance - k, centY, centZ, MODE_FIELD); break;
			case Side.PX: list.add(centX + distance + k, centY, centZ, MODE_FIELD); break;
			}
		}
	}
	
	@Override
	public int getBlockMode(int x, int y, int z) {
		int dist;
		switch(facing) {
		case Side.NX:
			if(y != centY || z != centZ) return 0;
			dist = centX - x;
			break;
		case Side.PX:
			if(y != centY || z != centZ) return 0;
			dist = x - centX;
			break;
		case Side.NY:
			if(x != centX || z != centZ) return 0;
			dist = centY - y;
			break;
		case Side.PY:
			if(x != centX || z != centZ) return 0;
			dist = y - centY;
			break;
		case Side.NZ:
			if(y != centY || x != centX) return 0;
			dist = centZ - z;
			break;
		case Side.PZ:
			if(y != centY || x != centX) return 0;
			dist = z - centZ;
			break;
		default:
			return 0;
		}
		
		if(dist < distance || dist > distance + length)
			return 0;
		
		return MODE_FIELD;
	}

}
