package mffs;

import immibis.core.net.AbstractSyncedContainer;
import immibis.core.net.IPacket;
import mffs.packet.PacketGenericUpdate;
import net.minecraft.src.Container;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Slot;

public class ContainerMFFS extends AbstractSyncedContainer {

	private TileEntityMFFS entity;
	private int updateCount = -1, baseUpdateCount = -1;

	public ContainerMFFS(EntityPlayer player, TileEntityMFFS tileentity) {
		super(player, tileentity);
		entity = tileentity;
	}
	
	@Override
	public void onButtonPressed(int id) {
		entity.handleButton(id);
	}

	@Override
	public ItemStack transferStackInSlot(int i) {
		return null;
	}

	@Override
	public String getChannel() {
		return mod_ModularForceFieldSystem.CHANNEL;
	}
	
	@Override
	public void onUpdatePacket(IPacket p) {
		if(p instanceof PacketGenericUpdate) {
			PacketGenericUpdate pgu = (PacketGenericUpdate)p;
			try {
				if(pgu.data.length > 0)
					entity.handleUpdate(pgu.data);
			} catch(ArrayIndexOutOfBoundsException e) {
			}
			try {
				if(pgu.baseData.length > 0)
					entity.handleBaseUpdate(pgu.baseData);
			} catch(ArrayIndexOutOfBoundsException e) {
			}
		}
	}
	
	@Override
	public void updateCraftingResults() {
		super.updateCraftingResults();
		if(entity.updateCount != updateCount || entity.baseUpdateCount != baseUpdateCount) {
			PacketGenericUpdate p = new PacketGenericUpdate();
			if(entity.updateCount != updateCount)
				p.data = entity.getUpdate();
			if(entity.baseUpdateCount != baseUpdateCount)
				p.baseData = entity.getBaseUpdate();
			sendUpdatePacket(p);
			updateCount = entity.updateCount;
			baseUpdateCount = entity.baseUpdateCount;
		}
	}

}