package mffs.projectors;

import ic2.api.Direction;
import ic2.api.EnergyNet;
import ic2.api.IEnergyConductor;
import ic2.common.TileEntityNuclearReactor;
import ic2.common.TileEntityReactorChamber;

import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;

import mffs.CoordinateList;
import mffs.Linkgrid;
import mffs.TileEntityGeneratorCore;
import mffs.TileEntityReaktorCooler;
import mffs.TileEntityReaktorMonitor;
import mffs.TileUpgradePassive;
import mffs.mod_ModularForceFieldSystem;
import net.minecraft.src.Container;
import net.minecraft.src.EntityItem;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ModLoader;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;

public class TileProjectorReactor extends TileProjector {

	private boolean watercool;
	private boolean isreaktor;
	private int reactorx = 0;
	private int reactory = 0;
	private int reactorz = 0;
	private int reactordist = 0;
	private int reactorsize = 0;
	private int reactorheat;
	private int maxheat;
	
	@Override
	public int[] getUpdate() {
		return new int[] {watercool?1:0, isreaktor?1:0, reactorx, reactory, reactorz, reactordist, reactorsize, reactorheat, maxheat}; 
	}

	@Override
	public void handleUpdate(int[] p) {
		watercool = p[0] != 0;
		isreaktor = p[1] != 0;
		reactorx = p[2];
		reactory = p[3];
		reactorz = p[4];
		reactordist = p[5];
		reactorsize = p[6];
		reactorheat = p[7];
		maxheat = p[8];
	}
	
	@Override
	public void handleButton(int id) {
		if(!getActive() && id == 0)
			setWatercool(!isWatercool());
	}

	public TileProjectorReactor() {

		isreaktor = false;
		reactorheat = 0;
		watercool = false;
		
		specialffmeta = (short)3;

	}

	public int getReactorx() {
		return reactorx;
	}

	public int getReactory() {
		return reactory;
	}

	public int getReactorz() {
		return reactorz;
	}

	public int getReactordist() {
		return reactordist;
	}

	public int getReactorsize() {
		return reactorsize;
	}

	public int getReactorheat() {
		return reactorheat;
	}

	public boolean isWatercool() {
		return watercool;
	}

	public void setWatercoolinit(boolean watercool) {

		this.watercool = watercool;
		updateCount++;
	}

	public void setWatercool(boolean watercool) {
		this.watercool = watercool;
		updateCount++;
	}

	public int getReaktorheat() {
		return reactorheat;
	}

	public void setReaktorheat(int reaktorheat) {
		this.reactorheat = reaktorheat;
		updateCount++;
	}

	public boolean isIsreaktor() {
		return isreaktor;
	}

	public void setIsreaktor(boolean isreaktor) {
		this.isreaktor = isreaktor;
		updateCount++;
	}

	public void readFromNBT(NBTTagCompound nbttagcompound) {

		super.readFromNBT(nbttagcompound);
		watercool = nbttagcompound.getBoolean("watercool");

	}

	public void writeToNBT(NBTTagCompound nbttagcompound) {

		super.writeToNBT(nbttagcompound);
		nbttagcompound.setBoolean("watercool", watercool);

	}

	private boolean scanforNuclearReaktor() {

		for (int x = xCoord - 2; x <= xCoord + 2; x++) {
			for (int y = yCoord - 2; y <= yCoord + 2; y++) {
				for (int z = zCoord - 2; z <= zCoord + 2; z++) {

					TileEntity tileEntity = worldObj.getBlockTileEntity(x, y, z);

					if (tileEntity instanceof TileEntityNuclearReactor) {
						reactorx = x;
						reactory = y;
						reactorz = z;

						if (Math.abs(xCoord - reactorx) <= 1 && Math.abs(yCoord - reactory) <= 1 && Math.abs(zCoord - reactorz) <= 1) {
							reactordist = 1;
						} else {
							reactordist = 2;
						}

						return true;
					}
				}
			}
		}
		return false;
	}

	private int scanforReaktorCamber() {

		int chamber = 0;

		if (worldObj.getBlockTileEntity(reactorx + 1, reactory, reactorz) instanceof TileEntityReactorChamber) {
			chamber++;
		}
		if (worldObj.getBlockTileEntity(reactorx - 1, reactory, reactorz) instanceof TileEntityReactorChamber) {
			chamber++;
		}
		if (worldObj.getBlockTileEntity(reactorx, reactory + 1, reactorz) instanceof TileEntityReactorChamber) {
			chamber++;
		}
		if (worldObj.getBlockTileEntity(reactorx, reactory - 1, reactorz) instanceof TileEntityReactorChamber) {
			chamber++;
		}
		if (worldObj.getBlockTileEntity(reactorx, reactory, reactorz + 1) instanceof TileEntityReactorChamber) {
			chamber++;
		}
		if (worldObj.getBlockTileEntity(reactorx, reactory, reactorz - 1) instanceof TileEntityReactorChamber) {
			chamber++;
		}
		return chamber;

	}
	
	@Override
	public boolean overrideActivationStatus(boolean activate) {
		if(!isIsreaktor()) {
			hardner = false;
			return false;
		}

		switch (reactorsize) {
		case 0:
			maxheat = 7500;
			break;
		case 1:
			maxheat = 8350;
			break;
		case 2:
			maxheat = 9200;
			break;
		case 3:
			maxheat = 10050;
			break;
		case 4:
			maxheat = 10900;
			break;
		case 5:
			maxheat = 11750;
			break;
		case 6:
			maxheat = 12600;
			break;
		}

		if (maxheat < reactorheat) {
			hardner = true;
			activate = true;
		}
		
		if(!getActive()) {
			if(reactorsize >= 1 && reactordist < 2)
				activate = false;
		}
		
		if(!activate)
			hardner = false;
		
		return activate;
	}
	
	@Override
	public void onEveryTick() {
		if(!isIsreaktor())
			setIsreaktor(scanforNuclearReaktor());
	}
	
	@Override
	public void onFieldTick() {
		if (isreaktor) {
			reactorsize = scanforReaktorCamber();
			TileEntity tileEntity = worldObj.getBlockTileEntity(reactorx, reactory, reactorz);

			if (tileEntity instanceof TileEntityNuclearReactor) {
				setReaktorheat(((TileEntityNuclearReactor) tileEntity).heat);
				if (getActive()) {
					refreshwater();
				}

			} else {

				setIsreaktor(false);

			}
		}
	}

	public void refreshwater() {
		if(!watercool)
			return;
		TileEntity generatorTE = Linkgrid.getWorldMap(worldObj).getGenerator().get(this.getLinkGenerator_ID());
		if(!(generatorTE instanceof TileEntityGeneratorCore))
			return;
		TileEntityGeneratorCore gen = (TileEntityGeneratorCore)generatorTE;
		for (int y1 = 0 - reactordist; y1 <= reactordist; y1++) {
			for (int x1 = 0 - reactordist; x1 <= reactordist; x1++) {
				for (int z1 = 0 - reactordist; z1 <= reactordist; z1++) {
					if (worldObj.getBlockId(reactorx + x1, reactory + y1, reactorz + z1) == 0) {
						worldObj.setBlockWithNotify(reactorx + x1, reactory + y1, reactorz + z1, 8);
						gen.Energylost(1000);
					}
				}
			}
		}
	}
	
	@Override
	public void onActivateProjector() {
		if(watercool)
			refreshwater();
	}
	
	@Override
	public void onDeactivateProjector() {
		if (watercool) {
			for (int y1 = 0 - reactordist; y1 <= reactordist; y1++) {
				for (int x1 = 0 - reactordist; x1 <= reactordist; x1++) {
					for (int z1 = 0 - reactordist; z1 <= reactordist; z1++) {

						if (worldObj.getBlockMaterial(reactorx + x1, reactory + y1, reactorz + z1).isLiquid()) {
							worldObj.setBlockWithNotify(reactorx + x1, reactory + y1, reactorz + z1, 0);

						}

					}
				}
			}
		}
	}

	/*@Override
	protected void getFieldShape(CoordinateList shape) {
		for (int y1 = 0 - reactordist; y1 <= reactordist; y1++) {
			for (int x1 = 0 - reactordist; x1 <= reactordist; x1++) {
				for (int z1 = 0 - reactordist; z1 <= reactordist; z1++) {
					if (x1 == 0 - reactordist || x1 == reactordist || y1 == 0 - reactordist || y1 == reactordist || z1 == 0 - reactordist || z1 == reactordist) {
						shape.add(reactorx + x1, reactory + y1, reactorz + z1);
					}
				}
			}
		}
	}*/
	
	@Override
	protected FFShape getFieldShape() {
		offsetX = reactorx - xCoord;
		offsetY = reactory - yCoord;
		offsetZ = reactorz - zCoord;
		return new FFShapeCube(this, reactordist);
	}

	@Override
	public void checkupgrades() {

		for (int x = 0 - 2; x <= 2; x++) {
			for (int y = 0 - 2; y <= 2; y++) {
				for (int z = 0 - 2; z <= 2; z++) {

					if ((x == 0 && y == 0 && (z == -2 || z == -1 || z == +1 || z == +2)) || (x == 0 && z == 0 && (y == -2 || y == -1 || y == +1 || y == +2)) || (z == 0 && y == 0 && (x == -2 || x == -1 || x == +1 || x == +2))) {

						if (worldObj.getBlockId(reactorx + x, reactory + y, reactorz + z) == mod_ModularForceFieldSystem.MFFSUpgrades.blockID) {

							int meta = worldObj.getBlockMetadata(reactorx + x, reactory + y, reactorz + z);

							TileEntity upgrades = worldObj.getBlockTileEntity(reactorx + x, reactory + y, reactorz + z);
							if (upgrades instanceof TileUpgradePassive) {
								if (((TileUpgradePassive) upgrades).getconectet_ID() == 0 && meta == 8) {
									((TileUpgradePassive) upgrades).setconectet_ID(getProjektor_ID());
									((TileUpgradePassive) upgrades).setConnectet_typID((short) 2);
									worldObj.markBlockAsNeedsUpdate(upgrades.xCoord, upgrades.yCoord, upgrades.zCoord);
								}

								if (((TileUpgradePassive) upgrades).getconectet_ID() == getProjektor_ID() && ((TileUpgradePassive) upgrades).getConnectet_typID() == 2) {

									if (((TileUpgradePassive) upgrades).getActive() != this.getActive()) {
										((TileUpgradePassive) upgrades).setActive(this.getActive());

									}

								}
							}
						}

					}
					if (worldObj.getBlockId(reactorx + x, reactory + y, reactorz + z) == mod_ModularForceFieldSystem.MFFSMaschines.blockID && worldObj.getBlockMetadata(reactorx + x, reactory + y, reactorz + z) == 8) {

						TileEntity reactorcooler = worldObj.getBlockTileEntity(reactorx + x, reactory + y, reactorz + z);
						if (reactorcooler instanceof TileUpgradePassive) {
							if (((TileUpgradePassive) reactorcooler).getconectet_ID() == 0) {
								((TileUpgradePassive) reactorcooler).setconectet_ID(getProjektor_ID());
								((TileUpgradePassive) reactorcooler).setConnectet_typID((short) 2);
								worldObj.markBlockAsNeedsUpdate(reactorcooler.xCoord, reactorcooler.yCoord, reactorcooler.zCoord);
							}

							if (((TileUpgradePassive) reactorcooler).getconectet_ID() == getProjektor_ID() && ((TileUpgradePassive) reactorcooler).getConnectet_typID() == 2) {

								if (((TileUpgradePassive) reactorcooler).getActive() != this.getActive()) {
									((TileUpgradePassive) reactorcooler).setActive(this.getActive());
									worldObj.markBlockAsNeedsUpdate(reactorcooler.xCoord, reactorcooler.yCoord, reactorcooler.zCoord);
								}
								if (((TileEntityReaktorCooler) reactorcooler).isIsreaktor() != this.isIsreaktor()) {
									((TileEntityReaktorCooler) reactorcooler).setIsreaktor(this.isIsreaktor());
								}
								if (((TileEntityReaktorCooler) reactorcooler).getMaxheat() != this.maxheat) {
									((TileEntityReaktorCooler) reactorcooler).setMaxheat(this.maxheat);
								}
								if (((TileEntityReaktorCooler) reactorcooler).getReaktorx() != this.reactorx) {
									((TileEntityReaktorCooler) reactorcooler).setReaktorx(this.reactorx);
								}
								if (((TileEntityReaktorCooler) reactorcooler).getReaktory() != this.reactory) {
									((TileEntityReaktorCooler) reactorcooler).setReaktory(this.reactory);
								}
								if (((TileEntityReaktorCooler) reactorcooler).getReaktorz() != this.reactorz) {
									((TileEntityReaktorCooler) reactorcooler).setReaktorz(this.reactorz);
								}

							}
						}

					}

					if (worldObj.getBlockId(reactorx + x, reactory + y, reactorz + z) == mod_ModularForceFieldSystem.MFFSMaschines.blockID && worldObj.getBlockMetadata(reactorx + x, reactory + y, reactorz + z) == 9) {

						TileEntity reactormonitor = worldObj.getBlockTileEntity(reactorx + x, reactory + y, reactorz + z);
						if (reactormonitor instanceof TileUpgradePassive) {
							if (((TileUpgradePassive) reactormonitor).getconectet_ID() == 0) {
								((TileUpgradePassive) reactormonitor).setconectet_ID(getProjektor_ID());
								((TileUpgradePassive) reactormonitor).setConnectet_typID((short) 2);
								worldObj.markBlockAsNeedsUpdate(reactormonitor.xCoord, reactormonitor.yCoord, reactormonitor.zCoord);
							}

							if (((TileUpgradePassive) reactormonitor).getconectet_ID() == getProjektor_ID() && ((TileUpgradePassive) reactormonitor).getConnectet_typID() == 2) {

								if (((TileUpgradePassive) reactormonitor).getActive() != this.getActive()) {
									((TileUpgradePassive) reactormonitor).setActive(this.getActive());
									worldObj.markBlockAsNeedsUpdate(reactormonitor.xCoord, reactormonitor.yCoord, reactormonitor.zCoord);
								}
								if (((TileEntityReaktorMonitor) reactormonitor).isIsreaktor() != this.isIsreaktor()) {
									((TileEntityReaktorMonitor) reactormonitor).setIsreaktor(this.isIsreaktor());
								}
								if (((TileEntityReaktorMonitor) reactormonitor).getReaktorx() != this.reactorx) {
									((TileEntityReaktorMonitor) reactormonitor).setReaktorx(this.reactorx);
								}
								if (((TileEntityReaktorMonitor) reactormonitor).getReaktory() != this.reactory) {
									((TileEntityReaktorMonitor) reactormonitor).setReaktory(this.reactory);
								}
								if (((TileEntityReaktorMonitor) reactormonitor).getReaktorz() != this.reactorz) {
									((TileEntityReaktorMonitor) reactormonitor).setReaktorz(this.reactorz);
								}
								if (((TileEntityReaktorMonitor) reactormonitor).getMaxheat() != this.maxheat) {
									((TileEntityReaktorMonitor) reactormonitor).setMaxheat(this.maxheat);
								}

							}
						}

					}

				}
			}
		}
		
		setffmeta((short)3);

	}

	@Override
	public ItemStack getStackInSlotOnClosing(int var1) {
		return null;
	}

	@Override
	public int estimateBlockCount() {
		return reactordist * reactordist * 24;
	}
}