package mffs.projectors;

import mffs.CoordinateList;

public abstract class FFShape
{
    public long activeTime;
    public int projX;
    public int projY;
    public int projZ;
    public int centX;
    public int centY;
    public int centZ;
    public boolean dome;
    public boolean breaker;
    public boolean subwater;
    public boolean inhibitor;
    public int ffmeta;
    public int genID;
    public int projID;
    public int camoBlock;

    public abstract void getFieldBlocks(CoordinateList var1);

    public abstract int getBlockMode(int var1, int var2, int var3);

    public FFShape(TileProjector var1)
    {
        this.projX = var1.x;
        this.projY = var1.y;
        this.projZ = var1.z;
        this.centX = this.projX + var1.offsetX;
        this.centY = this.projY + var1.offsetY;
        this.centZ = this.projZ + var1.offsetZ;
        this.activeTime = var1.activatedTime;
        this.dome = var1.isDome();
        this.breaker = var1.isBlockBreaker();
        this.subwater = var1.isSubwater();
        this.inhibitor = var1.isInhibitor();
        this.ffmeta = var1.getffmeta();
        this.projID = var1.getProjektor_ID();
        this.genID = var1.getLinkGenerator_ID();
        this.camoBlock = var1.getTextur();
    }
}
