package mffs;

import immibis.core.NonSharedProxy;
import mffs.projectors.TileProjector;
import mffs.projectors.TileProjectorExtender;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.ItemStack;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;

public class ItemMFD_offset extends ItemMFD
{
    public ItemMFD_offset(int var1)
    {
        super(var1, 2);
        this.d(5);
    }

    private int clamp(int var1)
    {
        return var1 < -TileProjector.maxOffset ? -TileProjector.maxOffset : (var1 > TileProjector.maxOffset ? TileProjector.maxOffset : var1);
    }

    /**
     * Callback for item usage. If the item does something special on right clicking, he will have one of those. Return
     * True if something happen and false if it don't. This is for ITEMS, not BLOCKS !
     */
    public boolean interactWith(ItemStack var1, EntityHuman var2, World var3, int var4, int var5, int var6, int var7)
    {
        TileEntity var8 = var3.getTileEntity(var4, var5, var6);

        if (var8 instanceof TileProjector && !(var8 instanceof TileProjectorExtender))
        {
            TileProjector var9 = (TileProjector)var8;

            if (var9.getActive())
            {
                NonSharedProxy.sendChat(var2, "Cannot move an active forcefield.");
                return true;
            }
            else
            {
                int var10 = var2.isSneaking() ? -1 : 1;

                switch (var7)
                {
                    case 0:
                        var9.offsetY = this.clamp(var9.offsetY + var10);
                        break;

                    case 1:
                        var9.offsetY = this.clamp(var9.offsetY - var10);
                        break;

                    case 2:
                        var9.offsetZ = this.clamp(var9.offsetZ + var10);
                        break;

                    case 3:
                        var9.offsetZ = this.clamp(var9.offsetZ - var10);
                        break;

                    case 4:
                        var9.offsetX = this.clamp(var9.offsetX + var10);
                        break;

                    case 5:
                        var9.offsetX = this.clamp(var9.offsetX - var10);
                }

                NonSharedProxy.sendChat(var2, "New field offset: " + var9.offsetX + "," + var9.offsetY + "," + var9.offsetZ);
                return true;
            }
        }
        else
        {
            return false;
        }
    }
}
