package mffs.projectors;

import mffs.CoordinateList;

public class FFShapeCube extends FFShape
{
    public int radius;
    public int minx;
    public int maxx;
    public int miny;
    public int maxy;
    public int minz;
    public int maxz;

    public FFShapeCube(TileProjector var1, int var2)
    {
        super(var1);
        this.radius = var2;
        this.minx = this.centX - var2;
        this.maxx = this.centX + var2;
        this.miny = Math.max(0, this.dome ? this.centY : this.centY - var2);
        this.maxy = Math.min(255, this.centY + var2);
        this.minz = this.centZ - var2;
        this.maxz = this.centZ + var2;
    }

    public void getFieldBlocks(CoordinateList var1)
    {
        int var2;
        int var3;

        for (var2 = this.minx; var2 <= this.maxx; ++var2)
        {
            for (var3 = this.miny; var3 <= this.maxy; ++var3)
            {
                var1.add(var2, var3, this.minz, 1);
                var1.add(var2, var3, this.maxz, 1);
            }
        }

        for (var2 = this.minx; var2 <= this.maxx; ++var2)
        {
            for (var3 = this.minz + 1; var3 <= this.maxz - 1; ++var3)
            {
                if (!this.dome)
                {
                    var1.add(var2, this.miny, var3, 1);
                }

                var1.add(var2, this.maxy, var3, 1);
            }
        }

        for (var2 = this.dome ? this.miny : this.miny + 1; var2 <= this.maxy - 1; ++var2)
        {
            for (var3 = this.minz + 1; var3 <= this.maxz - 1; ++var3)
            {
                var1.add(this.minx, var2, var3, 1);
                var1.add(this.maxx, var2, var3, 1);
            }
        }
    }

    public int getBlockMode(int var1, int var2, int var3)
    {
        return (var1 == this.minx || var1 == this.maxx) && var2 >= this.miny && var2 <= this.maxy && var3 >= this.minz && var3 <= this.maxz ? 1 : ((var3 == this.minz || var3 == this.maxz) && var2 >= this.miny && var2 <= this.maxy && var1 >= this.minx && var1 <= this.maxx ? 1 : ((var2 == this.maxy || var2 == this.miny && !this.dome) && var3 >= this.minz && var3 <= this.maxz && var1 >= this.minx && var1 <= this.maxx ? 1 : (this.inhibitor && var1 >= this.minx && var1 <= this.maxx && var2 >= this.miny && var2 <= this.maxy && var3 >= this.minz && var3 <= this.maxz ? 3 : 0)));
    }
}
