package mffs.projectors;

import mffs.CoordinateList;

public class FFShapeSphere extends FFShape
{
    public int radius;
    public int radiussq;
    public int radiusm1sq;
    public int minx;
    public int maxx;
    public int miny;
    public int maxy;
    public int minz;
    public int maxz;

    public FFShapeSphere(TileProjector var1, int var2)
    {
        super(var1);
        this.radius = var2;
        this.minx = this.centX - var2;
        this.maxx = this.centX + var2;
        this.miny = Math.max(0, this.dome ? this.centY : this.centY - var2);
        this.maxy = Math.min(255, this.centY + var2);
        this.minz = this.centZ - var2;
        this.maxz = this.centZ + var2;
        this.radiussq = var2 * var2;
        this.radiusm1sq = (var2 - 1) * (var2 - 1);
    }

    public void getFieldBlocks(CoordinateList var1)
    {
        for (int var2 = this.minx; var2 <= this.maxx; ++var2)
        {
            int var3 = var2 - this.centX;

            for (int var4 = this.minz; var4 <= this.maxz; ++var4)
            {
                int var5 = var4 - this.centZ;

                if (var3 * var3 + var5 * var5 <= this.radiussq)
                {
                    int var6 = (int)Math.sqrt((double)(this.radiussq - var3 * var3 - var5 * var5)) - this.radius / 2;
                    int var7 = var6 + this.radius;

                    for (int var8 = var6; var8 < var7; ++var8)
                    {
                        if (!this.dome && var8 > 0 && this.getBlockMode(var2, this.centY - var8, var4) == 1)
                        {
                            var1.add(var2, this.centY - var8, var4, 1);
                        }

                        if (var8 >= 0 && this.getBlockMode(var2, this.centY + var8, var4) == 1)
                        {
                            var1.add(var2, this.centY + var8, var4, 1);
                        }
                    }
                }
            }
        }
    }

    public int getBlockMode(int var1, int var2, int var3)
    {
        var1 -= this.centX;
        var2 -= this.centY;
        var3 -= this.centZ;

        if (var2 < 0 && this.dome)
        {
            return 0;
        }
        else if (var1 >= -this.radius && var1 <= this.radius && var2 >= -this.radius && var2 <= this.radius && var3 >= -this.radius && var3 <= this.radius)
        {
            int var4 = var1 * var1 + var2 * var2 + var3 * var3;
            return var4 <= this.radiusm1sq ? (this.inhibitor ? 3 : 0) : (var4 <= this.radiussq ? 1 : 0);
        }
        else
        {
            return 0;
        }
    }
}
