package mffs;

import forge.ISpecialResistance;
import java.util.Random;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.BlockContainer;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityBoat;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.Material;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;

public class BlockForceField extends BlockContainer implements ISpecialResistance
{
    private boolean localFlag;
    private StringBuffer hasher = new StringBuffer();
    static int model;
    public static final int META_NORMAL = 0;
    public static final int META_ZAPPER = 1;
    public static final int META_CAMO = 2;
    public static final int META_REACTOR = 3;
    public static final int META_ZAPPER_CAMO = 4;

    public static boolean isZapper(int var0)
    {
        return var0 == 1 || var0 == 4;
    }

    public static boolean isCamo(int var0)
    {
        return var0 == 2 || var0 == 4;
    }

    public BlockForceField(int var1)
    {
        super(var1, var1, Material.SHATTERABLE);
        this.c(100000.0F);
        this.b(6000.0F);
        this.localFlag = false;
        this.a(true);
    }

    /**
     * Ticks the block if it's been scheduled
     */
    public void a(World var1, int var2, int var3, int var4, Random var5)
    {
        FFBlock var6 = FFWorld.get(var1).get(var2, var3, var4);

        if (var6 == null)
        {
            var1.setTypeId(var2, var3, var4, 0);
        }
        else
        {
            var6.refresh();
        }
    }

    /**
     * The type of render function that is called for this block
     */
    public int c()
    {
        return model;
    }

    /**
     * Is this block (a) opaque and (b) a full 1m cube?  This determines whether or not to render the shared face of two
     * adjacent blocks and also whether the player can attach torches, redstone wire, etc to this block.
     */
    public boolean a()
    {
        return false;
    }

    /**
     * If this block doesn't render as an ordinary block it will return False (examples: signs, buttons, stairs, etc)
     */
    public boolean b()
    {
        return false;
    }

    protected boolean func_50008_h()
    {
        return false;
    }

    public int getRenderBlockPass()
    {
        return 1;
    }

    /**
     * Called whenever the block is removed.
     */
    public void remove(World var1, int var2, int var3, int var4)
    {
        if (!var1.isStatic)
        {
            FFBlock var5 = FFWorld.get(var1).get(var2, var3, var4);

            if (var5 != null && var5.shouldBeActive())
            {
                var5.refresh();
                FFWorld.get(var1).queueRefresh(var2, var3, var4);
            }
        }
    }

    /**
     * Returns a bounding box from the pool of bounding boxes (this means this box can change after the pool has been
     * cleared to be reused)
     */
    public AxisAlignedBB e(World var1, int var2, int var3, int var4)
    {
        if (isZapper(var1.getData(var2, var3, var4)))
        {
            float var5 = 0.0625F;
            return AxisAlignedBB.b((double)((float)var2 + var5), (double)((float)var3 + var5), (double)((float)var4 + var5), (double)((float)(var2 + 1) - var5), (double)((float)(var3 + 1) - var5), (double)((float)(var4 + 1) - var5));
        }
        else
        {
            return AxisAlignedBB.b((double)((float)var2), (double)var3, (double)((float)var4), (double)((float)(var2 + 1)), (double)((float)(var3 + 1)), (double)((float)(var4 + 1)));
        }
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World var1, int var2, int var3, int var4)
    {
        return AxisAlignedBB.b((double)((float)var2), (double)var3, (double)((float)var4), (double)((float)(var2 + 1)), (double)(var3 + 1), (double)((float)(var4 + 1)));
    }

    /**
     * Triggered whenever an entity collides with this block (enters into the block). Args: world, x, y, z, entity
     */
    public void a(World var1, int var2, int var3, int var4, Entity var5)
    {
        if (!var1.isStatic)
        {
            if (var5 instanceof EntityBoat)
            {
                var5.damageEntity(DamageSource.GENERIC, 50);
            }

            if (isZapper(var1.getData(var2, var3, var4)) && var5 instanceof EntityLiving)
            {
                var5.damageEntity(DamageSource.GENERIC, 5);
            }
        }
    }

    /**
     * Returns the quantity of items to drop on block destruction.
     */
    public int a(Random var1)
    {
        return 0;
    }

    /**
     * Called upon block activation (left or right click on the block.). The three integers represent x,y,z of the
     * block.
     */
    public boolean interact(World var1, int var2, int var3, int var4, EntityHuman var5)
    {
        return false;
    }

    public float getSpecialExplosionResistance(World var1, int var2, int var3, int var4, double var5, double var7, double var9, Entity var11)
    {
        if (!var1.isStatic)
        {
            FFBlock var12 = FFWorld.get(var1).get(var2, var3, var4);

            if (var12 != null && var12.shouldBeActive())
            {
                var12.usePower(mod_ModularForceFieldSystem.forcefieldblockcreatemodifier);
            }
        }

        return 60000.0F;
    }

    public void randomDisplayTick(World var1, int var2, int var3, int var4, Random var5)
    {
        int var6 = var1.getData(var2, var3, var4);

        if (isZapper(var6) && !isCamo(var6))
        {
            double var7 = (double)var2 + Math.random();
            double var9 = (double)var3 + Math.random();
            double var11 = (double)var4 + Math.random();
            var1.a("reddust", var7, var9, var11, 0.0D, 0.0D, 0.0D);
        }
    }

    /**
     * Returns the TileEntity used by this block.
     */
    public TileEntity a_()
    {
        throw new UnsupportedOperationException("This shouldn\'t happen");
    }

    public TileEntity getBlockEntity(int var1)
    {
        return isCamo(var1) ? new TileCamouflagedField() : null;
    }
}
