package mffs;

import forge.ISpecialResistance;
import forge.ITextureProvider;
import ic2.common.TileEntityReactorChamber;
import net.minecraft.server.Block;
import net.minecraft.server.BlockContainer;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;

public class BlockUpgrades extends BlockContainer implements ITextureProvider, ISpecialResistance
{
    private int blockid;
    public static final int META_REAKTOR_MONITOR_CLIENT = 0;
    public static final int META_SUBWATER = 1;
    public static final int META_DOME = 2;
    public static final int META_HARDNER = 3;
    public static final int META_CORE_STORAGE = 4;
    public static final int META_CORE_RANGE = 5;
    public static final int META_ZAPPER = 6;
    public static final int META_CAMO = 7;
    public static final int META_REACTOR_CONNECTOR = 8;
    public static final int META_INHIBITOR = 9;

    public BlockUpgrades(int var1)
    {
        super(var1, Material.ORE);
        this.blockid = var1;
        this.c(3.0F);
        this.b(50.0F);
        this.a(i);
    }

    public int getBlockid()
    {
        return this.blockid;
    }

    public int getGuiPro(World var1, int var2, int var3, int var4, EntityHuman var5)
    {
        switch (var1.getData(var2, var3, var4))
        {
            case 0:
                return 1;

            case 1:
                return 2;

            case 2:
                return 3;

            case 3:
                return 4;

            case 4:
                return 6;

            case 5:
                return 5;

            default:
                return -1;
        }
    }

    public int getGuiUp(World var1, int var2, int var3, int var4, EntityHuman var5)
    {
        switch (var1.getData(var2, var3, var4))
        {
            case 0:
                return 11;

            case 7:
                return 7;

            default:
                return -1;
        }
    }

    /**
     * Is this block indirectly powering the block on the specified side
     */
    public boolean d(World var1, int var2, int var3, int var4, int var5)
    {
        TileEntity var6 = var1.getTileEntity(var2, var3, var4);

        if (var6 instanceof TileEntityReaktorConnector && ((TileEntityReaktorConnector)var6).isredpowert())
        {
            switch (var5)
            {
                case 0:
                    if (var1.getTileEntity(var2, var3 + 1, var4) instanceof TileEntityReactorChamber)
                    {
                        return true;
                    }

                    break;

                case 1:
                    if (var1.getTileEntity(var2, var3 - 1, var4) instanceof TileEntityReactorChamber)
                    {
                        return true;
                    }

                    break;

                case 2:
                    if (var1.getTileEntity(var2, var3, var4 + 1) instanceof TileEntityReactorChamber)
                    {
                        return true;
                    }

                    break;

                case 3:
                    if (var1.getTileEntity(var2, var3, var4 - 1) instanceof TileEntityReactorChamber)
                    {
                        return true;
                    }

                    break;

                case 4:
                    if (var1.getTileEntity(var2 + 1, var3, var4) instanceof TileEntityReactorChamber)
                    {
                        return true;
                    }

                    break;

                case 5:
                    if (var1.getTileEntity(var2 - 1, var3, var4) instanceof TileEntityReactorChamber)
                    {
                        return true;
                    }

                    break;

                default:
                    return false;
            }
        }

        if (var6 instanceof TileEntityReaktorMonitorClient && ((TileEntityReaktorMonitorClient)var6).isSignal())
        {
            switch (var5)
            {
                case 0:
                    if (var1.getTileEntity(var2, var3 + 1, var4) instanceof TileEntityReaktorMonitorClient)
                    {
                        return false;
                    }

                    break;

                case 1:
                    if (var1.getTileEntity(var2, var3 - 1, var4) instanceof TileEntityReaktorMonitorClient)
                    {
                        return false;
                    }

                    break;

                case 2:
                    if (var1.getTileEntity(var2, var3, var4 + 1) instanceof TileEntityReaktorMonitorClient)
                    {
                        return false;
                    }

                    break;

                case 3:
                    if (var1.getTileEntity(var2, var3, var4 - 1) instanceof TileEntityReaktorMonitorClient)
                    {
                        return false;
                    }

                    break;

                case 4:
                    if (var1.getTileEntity(var2 + 1, var3, var4) instanceof TileEntityReaktorMonitorClient)
                    {
                        return false;
                    }

                    break;

                case 5:
                    if (var1.getTileEntity(var2 - 1, var3, var4) instanceof TileEntityReaktorMonitorClient)
                    {
                        return false;
                    }
            }

            return false;
        }
        else
        {
            return false;
        }
    }

    /**
     * Is this block powering the block on the specified side
     */
    public boolean a(IBlockAccess var1, int var2, int var3, int var4, int var5)
    {
        TileEntity var6 = var1.getTileEntity(var2, var3, var4);

        if (var6 instanceof TileEntityReaktorConnector)
        {
            if (((TileEntityReaktorConnector)var6).isredpowert())
            {
                switch (var5)
                {
                    case 0:
                        if (var1.getTileEntity(var2, var3 + 1, var4) instanceof TileEntityReactorChamber)
                        {
                            return true;
                        }

                        break;

                    case 1:
                        if (var1.getTileEntity(var2, var3 - 1, var4) instanceof TileEntityReactorChamber)
                        {
                            return true;
                        }

                        break;

                    case 2:
                        if (var1.getTileEntity(var2, var3, var4 + 1) instanceof TileEntityReactorChamber)
                        {
                            return true;
                        }

                        break;

                    case 3:
                        if (var1.getTileEntity(var2, var3, var4 - 1) instanceof TileEntityReactorChamber)
                        {
                            return true;
                        }

                        break;

                    case 4:
                        if (var1.getTileEntity(var2 + 1, var3, var4) instanceof TileEntityReactorChamber)
                        {
                            return true;
                        }

                        break;

                    case 5:
                        if (var1.getTileEntity(var2 - 1, var3, var4) instanceof TileEntityReactorChamber)
                        {
                            return true;
                        }

                        break;

                    default:
                        return false;
                }
            }

            return false;
        }
        else if (var6 instanceof TileEntityReaktorMonitorClient && ((TileEntityReaktorMonitorClient)var6).isSignal())
        {
            switch (var5)
            {
                case 0:
                    if (var1.getTileEntity(var2, var3 + 1, var4) instanceof TileEntityReaktorMonitorClient)
                    {
                        return false;
                    }

                    break;

                case 1:
                    if (var1.getTileEntity(var2, var3 - 1, var4) instanceof TileEntityReaktorMonitorClient)
                    {
                        return false;
                    }

                    break;

                case 2:
                    if (var1.getTileEntity(var2, var3, var4 + 1) instanceof TileEntityReaktorMonitorClient)
                    {
                        return false;
                    }

                    break;

                case 3:
                    if (var1.getTileEntity(var2, var3, var4 - 1) instanceof TileEntityReaktorMonitorClient)
                    {
                        return false;
                    }

                    break;

                case 4:
                    if (var1.getTileEntity(var2 + 1, var3, var4) instanceof TileEntityReaktorMonitorClient)
                    {
                        return false;
                    }

                    break;

                case 5:
                    if (var1.getTileEntity(var2 - 1, var3, var4) instanceof TileEntityReaktorMonitorClient)
                    {
                        return false;
                    }
            }

            return true;
        }
        else
        {
            return false;
        }
    }

    /**
     * Can this block provide power. Only wire currently seems to have this change based on its state.
     */
    public boolean isPowerSource()
    {
        return true;
    }

    /**
     * Called whenever the block is removed.
     */
    public void remove(World var1, int var2, int var3, int var4)
    {
        if (!var1.isStatic)
        {
            TileEntity var5 = var1.getTileEntity(var2, var3, var4);

            if (var5 instanceof TileEntityReaktorMonitorClient)
            {
                ItemStack var6 = ((TileEntityReaktorMonitorClient)var5).getItem(0);

                if (var6 != null && var6.getItem() instanceof ItemSecLinkCard)
                {
                    EntityItem var7 = new EntityItem(var1, (double)((float)var2), (double)((float)var3), (double)((float)var4), new ItemStack(mod_ModularForceFieldSystem.MFFSitemcardempty, 1));
                    var1.addEntity(var7);
                }
            }

            var1.q(var2, var3, var4);
        }
    }

    /**
     * Called upon block activation (left or right click on the block.). The three integers represent x,y,z of the
     * block.
     */
    public boolean interact(World var1, int var2, int var3, int var4, EntityHuman var5)
    {
        int var6 = this.getGuiUp(var1, var2, var3, var4, var5);
        int var7 = var1.getData(var2, var3, var4);

        if (var6 < 0 && var7 != 4 && var7 != 5)
        {
            return false;
        }
        else if (var5.U() != null && var5.U().id == Block.LEVER.id)
        {
            return false;
        }
        else if (var5.U() != null && var5.U().id == mod_ModularForceFieldSystem.MFFSUpgrades.id)
        {
            return false;
        }
        else if (var5.U() != null && var5.U().id == mod_ModularForceFieldSystem.MFFSMaschines.id)
        {
            return false;
        }
        else if (var5.U() != null && var5.U().getItem() instanceof ItemMFD)
        {
            return false;
        }
        else if (var6 >= 0)
        {
            if (!var1.isStatic)
            {
                var5.openGui(mod_ModularForceFieldSystem.instance, var6, var1, var2, var3, var4);
            }

            return true;
        }
        else
        {
            if (var7 == 4 || var7 == 5)
            {
                TileEntityPassivUpgrade var8 = (TileEntityPassivUpgrade)var1.getTileEntity(var2, var3, var4);

                if (var8.getconectet_ID() != 0)
                {
                    TileEntityGeneratorCore var9 = (TileEntityGeneratorCore)Linkgrid.getWorldMap(var1).getGenerator().get(Integer.valueOf(var8.getconectet_ID()));

                    if (var9 != null && !var1.isStatic)
                    {
                        int var10 = this.getGuiPro(var1, var9.x, var9.y, var9.z, var5);

                        if (var10 >= 0)
                        {
                            var5.openGui(mod_ModularForceFieldSystem.instance, var6, var1, var9.x, var9.y, var9.z);
                        }
                    }
                }
            }

            return false;
        }
    }

    public TileEntityMaschines getBlockEntity()
    {
        return null;
    }

    /**
     * Determines the damage on the item the block drops. Used in cloth and wood.
     */
    protected int getDropData(int var1)
    {
        return var1;
    }

    public TileEntityMaschines getBlockEntity(int var1)
    {
        switch (var1)
        {
            case 0:
                return new TileEntityReaktorMonitorClient();

            case 1:
            case 2:
            case 3:
            case 4:
            case 5:
            case 6:
            case 9:
                return new TileEntityPassivUpgrade();

            case 7:
                return new TileEntityCamoflageUpgrade();

            case 8:
                return new TileEntityReaktorConnector();

            default:
                return null;
        }
    }

    public String getTextureFile()
    {
        return "/mffs_grafik/upgrades.png";
    }

    public static boolean isActive(IBlockAccess var0, int var1, int var2, int var3)
    {
        TileEntity var4 = var0.getTileEntity(var1, var2, var3);
        return var4 instanceof TileEntityReaktorMonitorClient ? ((TileEntityReaktorMonitorClient)var4).isSignal() : (var4 instanceof TileEntityPassivUpgrade ? ((TileEntityPassivUpgrade)var4).getconectet_ID() != 0 : false);
    }

    public int getBlockTexture(IBlockAccess var1, int var2, int var3, int var4, int var5)
    {
        TileEntity var6 = var1.getTileEntity(var2, var3, var4);
        short var7 = var6 instanceof TileEntityMaschines ? ((TileEntityMaschines)var6).getFacing() : 0;
        int var8 = var1.getData(var2, var3, var4);
        return isActive(var1, var2, var3, var4) ? (var7 == var5 ? var8 * 16 + 7 : var8 * 16 + 7 + var5) : (var7 == var5 ? var8 * 16 : var8 * 16 + var5);
    }

    /**
     * From the specified side and block metadata retrieves the blocks texture. Args: side, metadata
     */
    public int a(int var1, int var2)
    {
        return var2 * 16 + var1 - 1;
    }

    /**
     * Lets the block know when one of its neighbor changes. Doesn't know which neighbor changed (coordinates passed are
     * their own) Args: x, y, z, neighbor blockID
     */
    public void doPhysics(World var1, int var2, int var3, int var4, int var5)
    {
        TileEntity var6 = var1.getTileEntity(var2, var3, var4);

        if (var6 instanceof TileEntityPassivUpgrade)
        {
            ((TileEntityPassivUpgrade)var6).updatecheck();
        }
    }

    public float getSpecialExplosionResistance(World var1, int var2, int var3, int var4, double var5, double var7, double var9, Entity var11)
    {
        if (var1.getTileEntity(var2, var3, var4) instanceof TileEntityMaschines)
        {
            TileEntity var12 = var1.getTileEntity(var2, var3, var4);
            return ((TileEntityMaschines)var12).getActive() ? 60000.0F : 50.0F;
        }
        else
        {
            return 50.0F;
        }
    }

    /**
     * Returns the TileEntity used by this block.
     */
    public TileEntity a_()
    {
        return this.getBlockEntity();
    }
}
