package mffs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import mffs.FFBlock.Entry;
import net.minecraft.server.*;
import static mffs.TileEntityProjektor.*;

public class FFBlock {
	
	public static class Entry {

		public Entry(int ffmeta, int genID, int projID, int mode, boolean blockBreaker, int camoBlock, long time) {
			this.ffmeta = (byte)ffmeta;
			this.genID = genID;
			this.projID = projID;
			this.mode = (byte)mode;
			this.blockBreaker = blockBreaker;
			this.camoBlock = camoBlock;
			this.time = time;
		}
		
		public int genID;
		public int projID;
		public byte mode;
		public byte ffmeta;
		public boolean blockBreaker;
		public int camoBlock;
		public long time;
	}
	
	public Entry activeEntry;
	public List<Entry> entries = new ArrayList<Entry>(2);
	public final int x, y, z;
	public final World w;

	public FFBlock(int x, int y, int z, World w) {
		this.x = x;
		this.y = y;
		this.z = z;
		this.w = w;
	}

	public int getFieldType() {
		return activeEntry == null ? 0 : activeEntry.ffmeta;
	}

	public boolean shouldBeActive() {
		return activeEntry != null && activeEntry.mode == MODE_FIELD;
	}
	
	public void usePower(int multiplier) {
		if(activeEntry == null)
			return;
		
		TileEntity genTE = (TileEntity)Linkgrid.getWorldMap(w).getGenerator().get(activeEntry.genID);
		if (genTE instanceof TileEntityGeneratorCore) {
			TileEntityGeneratorCore gen = (TileEntityGeneratorCore)genTE;
			
			int cost = mod_ModularForceFieldSystem.forcefieldblockcost * multiplier;
			if(BlockForceField.isZapper(getFieldType()))
				cost *= mod_ModularForceFieldSystem.forcefieldblockzappermodifier;
			
			gen.Energylost(cost);
		}
	}

	// returns true if anything changed
	public boolean refresh() {
		boolean didStuff = false;
		
		//System.out.println("FF refresh, shouldBeActive "+shouldBeActive());
		
		if(!shouldBeActive()) {
			if(w.getTypeId(x, y, z) == mod_ModularForceFieldSystem.MFFSFieldblock.id) {
				w.setTypeId(x, y, z, 0);
				didStuff = true;
			}
		}
		else
		{
			int oldBlock = w.getTypeId(x, y, z);
			if(oldBlock != 7 /* bedrock */ && (oldBlock != mod_ModularForceFieldSystem.MFFSFieldblock.id || w.getData(x, y, z) != getFieldType())) {
				if(oldBlock == 0 || oldBlock == mod_ModularForceFieldSystem.MFFSFieldblock.id || activeEntry.blockBreaker || !Block.byId[oldBlock].material.isSolid())
				{
					int oldMeta = w.getData(x, y, z);
					if(oldBlock != 0 && oldBlock != mod_ModularForceFieldSystem.MFFSFieldblock.id)
					{
						if(w.getTileEntity(x, y, z) != null)
							return false;

						Block b = Block.byId[oldBlock];
						w.setTypeId(x, y, z, 0);
						
						for(ItemStack is : b.getBlockDropped(w, x, y, z, oldMeta, 0))
							w.addEntity(new EntityItem(w, x + 0.5, y + 0.5, z + 0.5, is));
					}
					if(oldBlock != mod_ModularForceFieldSystem.MFFSFieldblock.id || oldMeta != getFieldType()) {
						w.setTypeId(x, y, z, 0);
						w.setTypeIdAndData(x, y, z, mod_ModularForceFieldSystem.MFFSFieldblock.id, getFieldType());
					}

					refreshCamo();
				
					usePower(mod_ModularForceFieldSystem.forcefieldblockcreatemodifier);
					
					didStuff = true;
				}
			}
		}
		
		if(activeEntry == null) {
			refreshActiveEntry();
			if(activeEntry == null) {
				FFWorld.get(w).remove(x, y, z);
			}
			didStuff = true;
		}
		
		return didStuff;
	}
	
	public void removeEntry(int projID) {
		Iterator<Entry> it = entries.iterator();
		while(it.hasNext())
			if(it.next().projID == projID) {
				it.remove();
				refreshActiveEntry();
				return;
			}
		//System.out.println("removeEntry("+projID+") failed");
	}

	public void addEntry(Entry entry) {
		
		// Remove any existing entry from this projector
		Iterator<Entry> it = entries.iterator();
		while(it.hasNext())
			if(it.next().projID == entry.projID) {
				it.remove();
				break;
			}
		
		// Insert entry into entries array, sorted by time.
		for(int k = 0; k < entries.size(); k++) {
			if(entries.get(k).time > entry.time) {
				entries.add(k, entry);
				refreshActiveEntry();
				return;
			}
		}
		entries.add(entry);
		refreshActiveEntry();
	}
	
	private void refreshActiveEntry() {
		
		// Most common case: one or zero entries
		if(entries.size() < 2) {
			Entry e = (entries.size() == 0 ? null : entries.get(0));
			
			if(activeEntry != e) {
				activeEntry = e;
				refresh();
				refreshCamo();
			}
			return;
		}
		
		/*
		 * A gap entry on any generator cancels ALL field entries on that generator.
		 * Forcefield is off if there are no non-cancelled field entries.
		 * If multiple fields from the same generator, first created is used.
		 * If multiple fields from different generators, first created is used.
		 * 
		 * Inhibitors override fields created after them, except from the same generator.
		 * If multiple inhibitors, only the most recent is used.
		 * 
		 * An inhibitor entry on any generator cancels ALL field entries 
		 */
		
		long inhibitTime = Long.MIN_VALUE;
		Entry inhibitor = null;
		
		Map<Integer, Entry> genMap = new HashMap<Integer, Entry>();
		for(Entry e : entries) {
			Entry oe = genMap.get(e.genID);
			if(e.mode == MODE_INHIBITOR) {
				if(e.time > inhibitTime) {
					inhibitor = e;
					inhibitTime = e.time;
				}
				return;
			}
			if(oe == null)
				genMap.put(e.genID, e);
			else if(oe.mode == MODE_FIELD && e.mode == MODE_GAP)
				genMap.put(e.genID, e);
		}
		
		Entry oldAE = activeEntry;
		
		activeEntry = null;
		for(Entry e : genMap.values()) {
			if(inhibitor != null && inhibitor.genID != e.genID && inhibitTime < e.time)
				continue;
			if(activeEntry == null) {
				activeEntry = e;
				continue;
			}
			if(e.mode == MODE_GAP)
				activeEntry = e;
			if(e.mode == MODE_FIELD && activeEntry.mode == MODE_GAP)
				// From different generators, fields override gaps
				activeEntry = e;
		}
		
		if(inhibitor != null) {
			if(activeEntry != null) {
				System.out.println("inh "+inhibitTime+"/"+inhibitor.genID);
				System.out.println("act "+activeEntry.time+"/"+activeEntry.genID);
				System.out.println();
			}
		}
		
		if(oldAE != activeEntry) {
			refresh();
			refreshCamo();
		}
	}

	public void useEnergyFor(int projektor_ID) {
		if(shouldBeActive() && activeEntry.projID == projektor_ID) {
			usePower(1);
		}
	}

	public void refreshCamo() {
		if(shouldBeActive() && BlockForceField.isCamo(getFieldType()) && w.getTypeId(x, y, z) == mod_ModularForceFieldSystem.MFFSFieldblock.id) {
			TileCamouflagedField tcf = ((TileCamouflagedField)w.getTileEntity(x, y, z));
			if(tcf == null)
				return;
			if(tcf.camoBlockId == activeEntry.camoBlock)
				return;
			tcf.camoBlockId = activeEntry.camoBlock;
			w.notify(x, y, z);
		}
	}

	public String getDebugInfo() {
		String s = "";
		s += "entries.size: " + entries.size();
		s += "\nactive mode: " + (activeEntry == null ? -1 : activeEntry.mode);
		return s;
	}

}
