package mffs;

import java.util.Random;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.TileEntity;

public abstract class TileEntityProjektor extends TileEntityMaschines
{
    public static final int MODE_FIELD = 1;
    public static final int MODE_GAP = 2;
    public static final int MODE_INHIBITOR = 3;
    private ItemStack[] ProjektorItemStacks;
    protected boolean camouflage = false;
    protected boolean zapper = false;
    protected boolean subwater = false;
    protected boolean dome = false;
    protected boolean hardner = false;
    protected boolean inhibitor = false;
    private int Projektor_ID;
    private int linkGenerator_ID;
    private boolean linkGenerator;
    private int linkPower;
    private int maxlinkPower;
    private short ticker;
    private int fpcost;
    private boolean create;
    private int energy_ticker = 0;
    private short ffmeta;
    private int textur;
    protected short specialffmeta = -1;
    private CoordinateList fieldBlocks = null;
    private CoordinateList refreshBlocks = null;
    private CoordinateList.CoordIterator refreshIterator;

    public void handleBaseUpdate(int[] var1)
    {
        this.Projektor_ID = var1[0];
        this.linkGenerator_ID = var1[1];
        this.linkPower = var1[2];
        this.maxlinkPower = var1[3];
        this.textur = var1[4];
    }

    public int[] getBaseUpdate()
    {
        return new int[] {this.Projektor_ID, this.linkGenerator_ID, this.linkPower, this.maxlinkPower, this.textur};
    }

    public TileEntityProjektor()
    {
        Random var1 = new Random();
        this.ProjektorItemStacks = new ItemStack[1];
        this.linkGenerator_ID = 0;
        this.Projektor_ID = var1.nextInt();
        this.linkGenerator = false;
        this.linkPower = 0;
        this.maxlinkPower = 1000000;
        this.ticker = 0;
        this.create = true;
        this.textur = -1;
        this.ffmeta = 0;
    }

    public final void addtogrid()
    {
        if (this.world.isStatic)
        {
            throw new RuntimeException("do not call this on smp clients");
        }
        else
        {
            Linkgrid.getWorldMap(this.world).getProjektor().put(Integer.valueOf(this.getProjektor_ID()), this);
        }
    }

    public final void removefromgrid()
    {
        if (this.world.isStatic)
        {
            throw new RuntimeException("do not call this on smp clients");
        }
        else
        {
            Linkgrid.getWorldMap(this.world).getProjektor().remove(Integer.valueOf(this.getProjektor_ID()));
        }
    }

    public abstract int estimateBlockCount();

    protected boolean acceptsUpgradeType(int var1)
    {
        return var1 == 7 ? true : (var1 == 6 ? true : var1 == 3);
    }

    public void checkupgrades()
    {
        this.subwater = false;
        this.dome = false;
        this.hardner = false;
        this.zapper = false;
        this.camouflage = false;
        this.inhibitor = false;

        for (int var1 = this.x - 1; var1 <= this.x + 1; ++var1)
        {
            for (int var2 = this.y - 1; var2 <= this.y + 1; ++var2)
            {
                for (int var3 = this.z - 1; var3 <= this.z + 1; ++var3)
                {
                    if (this.world.getTypeId(var1, var2, var3) == mod_ModularForceFieldSystem.MFFSUpgrades.id)
                    {
                        int var4 = this.world.getData(var1, var2, var3);
                        TileEntity var5 = this.world.getTileEntity(var1, var2, var3);

                        if (this.acceptsUpgradeType(var4) && var5 instanceof TileEntityPassivUpgrade)
                        {
                            if (((TileEntityPassivUpgrade)var5).getconectet_ID() == 0)
                            {
                                ((TileEntityPassivUpgrade)var5).setconectet_ID(this.getProjektor_ID());
                                ((TileEntityPassivUpgrade)var5).setConnectet_typID((short)2);
                                this.world.k(var5.x, var5.y, var5.z);
                            }

                            if (var4 == 7 && ((TileEntityCamoflageUpgrade)var5).getItem_ID() != this.getTextur())
                            {
                                this.setTextur(((TileEntityCamoflageUpgrade)var5).getItem_ID());
                            }

                            if (((TileEntityPassivUpgrade)var5).getconectet_ID() == this.getProjektor_ID() && ((TileEntityPassivUpgrade)var5).getConnectet_typID() == 2)
                            {
                                if (((TileEntityPassivUpgrade)var5).getActive() != this.getActive())
                                {
                                    ((TileEntityPassivUpgrade)var5).setActive(this.getActive());
                                }

                                switch (var4)
                                {
                                    case 1:
                                        this.subwater = true;
                                        break;

                                    case 2:
                                        this.dome = true;
                                        break;

                                    case 3:
                                        this.hardner = true;

                                    case 4:
                                    case 5:
                                    case 8:
                                    default:
                                        break;

                                    case 6:
                                        this.zapper = true;
                                        break;

                                    case 7:
                                        this.camouflage = true;
                                        break;

                                    case 9:
                                        this.inhibitor = true;
                                }
                            }
                        }
                    }
                }
            }
        }

        if (this.specialffmeta != -1)
        {
            this.setffmeta(this.specialffmeta);
        }
        else if (this.isCamouflage() && this.isZapper())
        {
            this.setffmeta((short)4);
        }
        else if (this.isCamouflage())
        {
            this.setffmeta((short)2);
        }
        else if (this.isZapper())
        {
            this.setffmeta((short)1);
        }
        else
        {
            this.setffmeta((short)0);
        }
    }

    protected abstract void getFieldShape(CoordinateList var1);

    private final boolean needsRefreshing(int var1)
    {
        return var1 == 1;
    }

    protected final void createField()
    {
        this.fieldBlocks = new CoordinateList(this.estimateBlockCount());
        this.getFieldShape(this.fieldBlocks);
        int var1 = 0;
        CoordinateList.CoordIterator var2 = this.fieldBlocks.iterate();

        while (var2.hasNext())
        {
            var2.next();

            if (this.needsRefreshing(var2.mode))
            {
                ++var1;
            }
        }

        this.refreshBlocks = new CoordinateList(var1);
        var2 = this.fieldBlocks.iterate();

        while (var2.hasNext())
        {
            var2.next();

            if (this.needsRefreshing(var2.mode))
            {
                this.refreshBlocks.add(var2.x, var2.y, var2.z, var2.mode);
            }
        }

        this.refreshIterator = this.refreshBlocks.iterate();
        CoordinateList.CoordIterator var3 = this.fieldBlocks.iterate();

        while (var3.hasNext())
        {
            var3.next();
            FFBlock var4 = FFWorld.get(this.world).addOrGet(var3.x, var3.y, var3.z);
            var4.addEntry(new FFBlock.Entry(this.getffmeta(), this.getLinkGenerator_ID(), this.getProjektor_ID(), var3.mode, this.isBlockBreaker(), this.getTextur(), this.activatedTime));
        }
    }

    public void onActivateProjector() {}

    public void onDeactivateProjector() {}

    public void onEveryTick() {}

    public void onFieldTick() {}

    public boolean overrideActivationStatus(boolean var1)
    {
        return var1;
    }

    /**
     * Allows the entity to update its state. Overridden in most subclasses, e.g. the mob spawner uses this to count
     * ticks and creates a new spawn inside its implementation.
     */
    public void q_()
    {
        if (!this.world.isStatic)
        {
            if (this.isCreate() && this.getLinkGenerator_ID() != 0)
            {
                this.addtogrid();
                this.addfreqcard();
                this.setCreate(false);

                if (this.getActive())
                {
                    this.checkupgrades();
                    this.onActivateProjector();
                    this.createField();
                }
            }

            if (this.getLinkGenerator_ID() != 0)
            {
                this.setLinkGenerator(true);

                try
                {
                    this.setLinkPower(((TileEntityGeneratorCore)Linkgrid.getWorldMap(this.world).getGenerator().get(Integer.valueOf(this.getLinkGenerator_ID()))).getForcepower());
                    this.setMaxlinkPower(((TileEntityGeneratorCore)Linkgrid.getWorldMap(this.world).getGenerator().get(Integer.valueOf(this.getLinkGenerator_ID()))).getMaxforcepower());
                }
                catch (NullPointerException var4)
                {
                    this.setLinkGenerator(false);
                    this.setLinkPower(0);
                    this.setMaxlinkPower(1000000);
                }
            }
            else
            {
                this.setLinkGenerator(false);
                this.setLinkPower(0);
                this.setMaxlinkPower(1000000);
            }

            boolean var1 = this.world.isBlockPowered(this.x, this.y, this.z);
            boolean var2 = this.world.isBlockIndirectlyPowered(this.x, this.y, this.z);
            boolean var3 = this.overrideActivationStatus(var1 || var2);

            if (var3 && this.isLinkGenerator() && this.getLinkPower() > this.Forcepowerneed(this.estimateBlockCount(), true) && !this.getActive())
            {
                this.setActive(true);
                this.createField();
                this.FieldGenerate(true);
                this.onActivateProjector();
                this.world.notify(this.x, this.y, this.z);
            }

            if ((!var3 || !this.isLinkGenerator() || this.getLinkPower() < this.Forcepowerneed(this.estimateBlockCount(), false)) && this.getActive())
            {
                this.setActive(false);
                this.onDeactivateProjector();
                this.destroyField();
                this.world.notify(this.x, this.y, this.z);
            }

            if (this.getActive() && this.getWrenchDropRate() != -1.0F)
            {
                this.setWrenchRate(-1.0F);
            }

            if (!this.getActive() && this.getWrenchDropRate() != 1.0F)
            {
                this.setWrenchRate(1.0F);
            }

            this.onEveryTick();

            if (this.getActive())
            {
                this.FieldGenerate(false);
            }

            if (this.getTicker() == 10)
            {
                this.checkupgrades();
                this.addfreqcard();
                this.onFieldTick();
                this.setTicker((short)0);
            }

            this.setTicker((short)(this.getTicker() + 1));
        }
    }

    protected final void destroyField()
    {
        if (this.fieldBlocks != null)
        {
            CoordinateList.CoordIterator var1 = this.fieldBlocks.iterate();

            while (var1.hasNext())
            {
                var1.next();
                FFBlock var2 = FFWorld.get(this.world).get(var1.x, var1.y, var1.z);

                if (var2 != null)
                {
                    var2.removeEntry(this.getProjektor_ID());
                }
            }
        }
    }

    public boolean isCreate()
    {
        return this.create;
    }

    public void setCreate(boolean var1)
    {
        this.create = var1;
    }

    public short getTicker()
    {
        return this.ticker;
    }

    public void setTicker(short var1)
    {
        this.ticker = var1;
    }

    public int getTextur()
    {
        return this.textur;
    }

    public void setTextur(int var1)
    {
        this.textur = var1;
        ++this.baseUpdateCount;
    }

    public short getffmeta()
    {
        return this.ffmeta;
    }

    public void setffmeta(short var1)
    {
        this.ffmeta = var1;
    }

    public int getMaxlinkPower()
    {
        return this.maxlinkPower;
    }

    public void setMaxlinkPower(int var1)
    {
        this.maxlinkPower = var1;
        ++this.baseUpdateCount;
    }

    public boolean isLinkGenerator()
    {
        return this.linkGenerator;
    }

    public void setLinkGenerator(boolean var1)
    {
        this.linkGenerator = var1;
        ++this.baseUpdateCount;
    }

    public int getLinkPower()
    {
        return this.linkPower;
    }

    public void setLinkPower(int var1)
    {
        this.linkPower = var1;
        ++this.baseUpdateCount;
    }

    public int getLinkGenerator_ID()
    {
        return this.linkGenerator_ID;
    }

    public void setLinkGenerator_ID(int var1)
    {
        this.linkGenerator_ID = var1;
        ++this.baseUpdateCount;
    }

    public boolean isCamouflage()
    {
        return this.camouflage;
    }

    public boolean isZapper()
    {
        return this.zapper;
    }

    public boolean isSubwater()
    {
        return this.subwater;
    }

    public boolean isDome()
    {
        return this.dome;
    }

    public boolean isBlockBreaker()
    {
        return this.hardner;
    }

    public boolean isInhibitor()
    {
        return this.inhibitor;
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.Projektor_ID = var1.getInt("Projektor_ID");
        this.ffmeta = var1.getShort("ffmeta");
        this.textur = var1.getInt("textur");
        NBTTagList var2 = var1.getList("Items");
        this.ProjektorItemStacks = new ItemStack[this.getSize()];

        for (int var3 = 0; var3 < var2.size(); ++var3)
        {
            NBTTagCompound var4 = (NBTTagCompound)var2.get(var3);
            byte var5 = var4.getByte("Slot");

            if (var5 >= 0 && var5 < this.ProjektorItemStacks.length)
            {
                this.ProjektorItemStacks[var5] = ItemStack.a(var4);
            }
        }
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setInt("Projektor_ID", this.Projektor_ID);
        var1.setShort("ffmeta", this.ffmeta);
        var1.setInt("textur", this.textur);
        NBTTagList var2 = new NBTTagList();

        for (int var3 = 0; var3 < this.ProjektorItemStacks.length; ++var3)
        {
            if (this.ProjektorItemStacks[var3] != null)
            {
                NBTTagCompound var4 = new NBTTagCompound();
                var4.setByte("Slot", (byte)var3);
                this.ProjektorItemStacks[var3].save(var4);
                var2.add(var4);
            }
        }

        var1.set("Items", var2);
    }

    public int getProjektor_ID()
    {
        return this.Projektor_ID;
    }

    public void FieldGenerate(boolean var1)
    {
        if (this.fieldBlocks == null)
        {
            this.createField();
        }

        boolean var2 = false;
        boolean var3 = true;

        if (!var1 && this.energy_ticker != 20)
        {
            ++this.energy_ticker;

            if (mod_ModularForceFieldSystem.slowRefresh)
            {
                return;
            }
        }
        else
        {
            CoordinateList.CoordIterator var4 = this.fieldBlocks.iterate();

            while (var4.hasNext())
            {
                var4.next();
                FFBlock var5 = FFWorld.get(this.world).get(var4.x, var4.y, var4.z);

                if (var5 != null)
                {
                    var5.useEnergyFor(this.getProjektor_ID());
                }
            }

            this.energy_ticker = 0;
        }

        int var8 = mod_ModularForceFieldSystem.refreshSpeed;

        if (var8 == 0)
        {
            var8 = Integer.MAX_VALUE;
        }

        CoordinateList.CoordIterator var9 = this.refreshIterator;
        FFWorld var6 = FFWorld.get(this.world);

        while (var9.hasNext() && var8 > 0)
        {
            var9.next();
            --var8;
            FFBlock var7 = var6.get(var9.x, var9.y, var9.z);

            if (var7 != null)
            {
                var7.refresh();
            }
        }

        if (!var9.hasNext())
        {
            this.refreshIterator = this.refreshBlocks.iterate();
        }
    }

    public int Forcepowerneed(int var1, boolean var2)
    {
        int var3 = var1 * mod_ModularForceFieldSystem.forcefieldblockcost;

        if (var2)
        {
            var3 = var3 * mod_ModularForceFieldSystem.forcefieldblockcreatemodifier + var3 * 5;
        }

        return var3;
    }

    public void addfreqcard()
    {
        if (this.getItem(0) != null)
        {
            if (this.getItem(0).getItem() == mod_ModularForceFieldSystem.MFFSitemfc && this.linkGenerator_ID != Functions.getTAGfromItemstack(this.getItem(0)).getInt("Generator_ID"))
            {
                this.linkGenerator_ID = Functions.getTAGfromItemstack(this.getItem(0)).getInt("Generator_ID");
            }
        }
        else
        {
            this.linkGenerator_ID = 0;
        }
    }

    /**
     * Decrease the size of the stack in slot (first int arg) by the amount of the second int arg. Returns the new
     * stack.
     */
    public ItemStack splitStack(int var1, int var2)
    {
        if (this.ProjektorItemStacks[var1] != null)
        {
            ItemStack var3;

            if (this.ProjektorItemStacks[var1].count <= var2)
            {
                var3 = this.ProjektorItemStacks[var1];
                this.ProjektorItemStacks[var1] = null;
                return var3;
            }
            else
            {
                var3 = this.ProjektorItemStacks[var1].a(var2);

                if (this.ProjektorItemStacks[var1].count == 0)
                {
                    this.ProjektorItemStacks[var1] = null;
                }

                return var3;
            }
        }
        else
        {
            return null;
        }
    }

    /**
     * Sets the given item stack to the specified slot in the inventory (can be crafting or armor sections).
     */
    public void setItem(int var1, ItemStack var2)
    {
        this.ProjektorItemStacks[var1] = var2;

        if (var2 != null && var2.count > this.getMaxStackSize())
        {
            var2.count = this.getMaxStackSize();
        }
    }

    public boolean canInteractWith(EntityHuman var1)
    {
        return this.world.getTileEntity(this.x, this.y, this.z) != this ? false : var1.e((double)this.x + 0.5D, (double)this.y + 0.5D, (double)this.z + 0.5D) <= 64.0D;
    }

    /**
     * Returns the stack in slot i
     */
    public ItemStack getItem(int var1)
    {
        return this.ProjektorItemStacks[var1];
    }

    /**
     * Returns the name of the inventory.
     */
    public String getName()
    {
        return "Projektor";
    }

    /**
     * Returns the maximum stack size for a inventory slot. Seems to always be 64, possibly will be extended. *Isn't
     * this more of a set than a get?*
     */
    public int getMaxStackSize()
    {
        return 1;
    }

    /**
     * Returns the number of slots in the inventory.
     */
    public int getSize()
    {
        return this.ProjektorItemStacks.length;
    }

    /**
     * Do not make give this method the name canInteractWith because it clashes with Container
     */
    public boolean a(EntityHuman var1)
    {
        return this.world.getTileEntity(this.x, this.y, this.z) != this ? false : var1.f((double)this.x + 0.5D, (double)this.y + 0.5D, (double)this.z + 0.5D) <= 64.0D;
    }

    public void f() {}

    public void g() {}
}
