package mffs;

import net.minecraft.server.EntityHuman;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.TileEntity;

public class TileEntityDirectionalProjektor extends TileEntityProjektor
{
    private int length = 1;
    private int maxlength;
    private int distance = 0;
    private int maxdistance;

    public TileEntityDirectionalProjektor()
    {
        this.maxlength = mod_ModularForceFieldSystem.maxSize;
        this.maxdistance = 10;
    }

    public void handleButton(int var1)
    {
        if (!this.getActive())
        {
            switch (var1)
            {
                case 0:
                    if (!this.getActive() && this.getlength() < this.getMaxlength())
                    {
                        this.setlength(this.getlength() + 1);
                    }

                    break;

                case 1:
                    if (!this.getActive() && this.getlength() > 1)
                    {
                        this.setlength(this.getlength() - 1);
                    }

                    break;

                case 2:
                    if (!this.getActive() && this.getDistance() < this.getMaxdistance())
                    {
                        this.setDistance(this.getDistance() + 1);
                    }

                    break;

                case 3:
                    if (!this.getActive() && this.getDistance() > 0)
                    {
                        this.setDistance(this.getDistance() - 1);
                    }
            }
        }
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.length = var1.getInt("length");
        this.distance = var1.getInt("distance");
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setInt("length", this.length);
        var1.setInt("distance", this.distance);
    }

    public void Check_con_Extender()
    {
        for (int var1 = this.x - 1; var1 <= this.x + 1; ++var1)
        {
            for (int var2 = this.y - 1; var2 <= this.y + 1; ++var2)
            {
                for (int var3 = this.z - 1; var3 <= this.z + 1; ++var3)
                {
                    TileEntity var4 = this.world.getTileEntity(var1, var2, var3);

                    if (var4 != null && var4 instanceof TileEntityDirectionalExtender)
                    {
                        if (((TileEntityDirectionalExtender)var4).getRemProjektor_ID() == 0 && !((TileEntityDirectionalExtender)var4).isCon_to_projektor() && this.getLinkGenerator_ID() != 0 && this.getProjektor_ID() != 0)
                        {
                            ((TileEntityDirectionalExtender)var4).setRemGenerator_ID(this.getLinkGenerator_ID());
                            ((TileEntityDirectionalExtender)var4).setRemProjektor_ID(this.getProjektor_ID());
                            ((TileEntityDirectionalExtender)var4).setCon_to_projektor(true);
                        }

                        if (((TileEntityDirectionalExtender)var4).isCon_to_projektor())
                        {
                            if (((TileEntityDirectionalExtender)var4).getffmeta() != this.getffmeta())
                            {
                                ((TileEntityDirectionalExtender)var4).setffmeta(this.getffmeta());
                            }

                            if (((TileEntityDirectionalExtender)var4).getTextur() != this.getTextur())
                            {
                                ((TileEntityDirectionalExtender)var4).setTextur(this.getTextur());
                            }

                            if (((TileEntityDirectionalExtender)var4).getFacing() != this.getFacing())
                            {
                                ((TileEntityDirectionalExtender)var4).setFacing(this.getFacing());
                                this.world.notify(var1, var2, var3);
                            }

                            if (((TileEntityDirectionalExtender)var4).getDistance() != this.getDistance())
                            {
                                ((TileEntityDirectionalExtender)var4).setDistance(this.getDistance());
                            }

                            if (((TileEntityDirectionalExtender)var4).getLength() != this.getlength())
                            {
                                ((TileEntityDirectionalExtender)var4).setlength(this.getlength());
                            }

                            if (((TileEntityDirectionalExtender)var4).isBlockBreaker() != this.isBlockBreaker())
                            {
                                ((TileEntityDirectionalExtender)var4).hardner = this.isBlockBreaker();
                            }

                            if (((TileEntityDirectionalExtender)var4).isPreactive() != this.getActive())
                            {
                                ((TileEntityDirectionalExtender)var4).setPreactive(this.getActive());
                            }
                        }
                    }
                }
            }
        }
    }

    public int getMaxlength()
    {
        return this.maxlength;
    }

    public int getlength()
    {
        return this.length;
    }

    public int getDistance()
    {
        return this.distance;
    }

    public int getMaxdistance()
    {
        return this.maxdistance;
    }

    public void setDistance(int var1)
    {
        this.distance = var1;
        ++this.updateCount;
    }

    public void setDistanceinit(int var1)
    {
        this.distance = var1;
        ++this.updateCount;
    }

    public void setlength(int var1)
    {
        this.length = var1;
        ++this.updateCount;
    }

    public void setlengthinit(int var1)
    {
        this.length = var1;
        ++this.updateCount;
    }

    public boolean wrenchCanSetFacing(EntityHuman var1, int var2)
    {
        if (this.getFacing() != var2 && !this.getActive())
        {
            this.setFacing((short)var2);
            this.world.notify(this.x, this.y, this.z);
            return true;
        }
        else
        {
            return false;
        }
    }

    public void checkupgrades()
    {
        super.checkupgrades();
        this.Check_con_Extender();
    }

    public void getFieldShape(CoordinateList var1)
    {
        int var2 = 0;
        int var3 = 0;
        int var4 = 0;

        for (int var5 = 1; var5 < this.getlength() + 1; ++var5)
        {
            if (this.getFacing() == 0)
            {
                var3 = var5 - var5 - var5 - this.distance;
            }

            if (this.getFacing() == 1)
            {
                var3 = var5 + this.distance;
            }

            if (this.getFacing() == 2)
            {
                var4 = var5 - var5 - var5 - this.distance;
            }

            if (this.getFacing() == 3)
            {
                var4 = var5 + this.distance;
            }

            if (this.getFacing() == 4)
            {
                var2 = var5 - var5 - var5 - this.distance;
            }

            if (this.getFacing() == 5)
            {
                var2 = var5 + this.distance;
            }

            var1.add(this.x + var2, this.y + var3, this.z + var4);
        }
    }

    /**
     * When some containers are closed they call this on each slot, then drop whatever it returns as an EntityItem -
     * like when you close a workbench GUI.
     */
    public ItemStack splitWithoutUpdate(int var1)
    {
        return null;
    }

    public int[] getUpdate()
    {
        return new int[] {this.length, this.maxlength, this.distance, this.maxdistance};
    }

    public void handleUpdate(int[] var1)
    {
        this.length = var1[0];
        this.maxlength = var1[1];
        this.distance = var1[2];
        this.maxdistance = var1[3];
    }

    public int estimateBlockCount()
    {
        return this.getlength();
    }
}
