package mffs;

import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import net.minecraft.src.Container;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ModLoader;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;

public class TileEntityDirectionalProjektor extends TileEntityProjektor {

	private int length;
	private int maxlength;
	private int distance;
	private int maxdistance;

	public TileEntityDirectionalProjektor() {

		length = 1;
		distance = 0;
		maxlength = mod_ModularForceFieldSystem.maxSize;
		maxdistance = 10;

	}

	@Override
	public void handleButton(int id) {
		if (!getActive()) {
			switch (id) {

			case 0:
				if (getActive() == false) {

					if (getlength() < getMaxlength()) {

						setlength(getlength() + 1);
					}
				}
				break;
			case 1:
				if (getActive() == false) {

					if (getlength() > 1) {
						setlength(getlength() - 1);
					}

				}
				break;
			case 2:
				if (getActive() == false) {

					if (getDistance() < getMaxdistance()) {
						setDistance(getDistance() + 1);
					}
				}
				break;
			case 3:
				if (getActive() == false) {

					if (getDistance() > 0) {
						setDistance(getDistance() - 1);
					}

				}
				break;

			}
		}
	}

	public void readFromNBT(NBTTagCompound nbttagcompound) {

		super.readFromNBT(nbttagcompound);
		length = nbttagcompound.getInteger("length");
		distance = nbttagcompound.getInteger("distance");

	}

	public void writeToNBT(NBTTagCompound nbttagcompound) {

		super.writeToNBT(nbttagcompound);
		nbttagcompound.setInteger("length", length);
		nbttagcompound.setInteger("distance", distance);

	}

	public void Check_con_Extender() {
		for (int x = xCoord - 1; x <= xCoord + 1; x++) {
			for (int y = yCoord - 1; y <= yCoord + 1; y++) {
				for (int z = zCoord - 1; z <= zCoord + 1; z++) {

					TileEntity tileEntity = worldObj.getBlockTileEntity(x, y, z);

					if (tileEntity != null) {
						if (tileEntity instanceof TileEntityDirectionalExtender) {
							if (((TileEntityDirectionalExtender) tileEntity).getRemProjektor_ID() == 0 && ((TileEntityDirectionalExtender) tileEntity).isCon_to_projektor() == false && this.getLinkGenerator_ID() != 0 && this.getProjektor_ID() != 0) {

								((TileEntityDirectionalExtender) tileEntity).setRemGenerator_ID(this.getLinkGenerator_ID());
								((TileEntityDirectionalExtender) tileEntity).setRemProjektor_ID(this.getProjektor_ID());
								((TileEntityDirectionalExtender) tileEntity).setCon_to_projektor(true);
							}
							if (((TileEntityDirectionalExtender) tileEntity).isCon_to_projektor() == true) {

								if (((TileEntityDirectionalExtender) tileEntity).getffmeta() != this.getffmeta()) {
									((TileEntityDirectionalExtender) tileEntity).setffmeta(this.getffmeta());
								}
								if (((TileEntityDirectionalExtender) tileEntity).getTextur() != this.getTextur()) {
									((TileEntityDirectionalExtender) tileEntity).setTextur(this.getTextur());
								}

								if (((TileEntityDirectionalExtender) tileEntity).getFacing() != this.getFacing()) {
									((TileEntityDirectionalExtender) tileEntity).setFacing(this.getFacing());
									worldObj.markBlockNeedsUpdate(x, y, z);
								}
								if (((TileEntityDirectionalExtender) tileEntity).getDistance() != this.getDistance()) {
									((TileEntityDirectionalExtender) tileEntity).setDistance(this.getDistance());
								}

								if (((TileEntityDirectionalExtender) tileEntity).getLength() != this.getlength()) {
									((TileEntityDirectionalExtender) tileEntity).setlength(this.getlength());
								}
								if (((TileEntityDirectionalExtender) tileEntity).isBlockBreaker() != this.isBlockBreaker()) {
									((TileEntityDirectionalExtender) tileEntity).hardner = this.isBlockBreaker();
								}
								if (((TileEntityDirectionalExtender) tileEntity).isPreactive() != this.getActive()) {
									((TileEntityDirectionalExtender) tileEntity).setPreactive(this.getActive());
								}

							}

						}
					}
				}
			}
		}
	}

	public int getMaxlength() {
		return maxlength;
	}

	public int getlength() {
		return length;
	}

	public int getDistance() {
		return distance;
	}

	public int getMaxdistance() {
		return maxdistance;
	}

	public void setDistance(int distance) {

		this.distance = distance;
		updateCount++;
	}

	public void setDistanceinit(int distance) {

		this.distance = distance;
		updateCount++;
	}

	public void setlength(int length) {

		this.length = length;
		updateCount++;
	}

	public void setlengthinit(int length) {

		this.length = length;
		updateCount++;
	}

	public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {

		if (this.getFacing() != side && (!this.getActive())) {
			this.setFacing((short) side);

			worldObj.markBlockNeedsUpdate(xCoord, yCoord, zCoord);
			return true;
		}
		return false;
	}
	
	@Override
	public void checkupgrades() {
		super.checkupgrades();
		Check_con_Extender();
	}

	@Override
	public void getFieldShape(CoordinateList shape) {
		int tempx = 0;
		int tempy = 0;
		int tempz = 0;

		for (int y1 = 1; y1 < getlength() + 1; y1++) {

			if (this.getFacing() == 0) {
				tempy = y1 - y1 - y1 - distance;
			}

			if (this.getFacing() == 1) {
				tempy = y1 + distance;
			}

			if (this.getFacing() == 2) {
				tempz = y1 - y1 - y1 - distance;
			}

			if (this.getFacing() == 3) {
				tempz = y1 + distance;
			}

			if (this.getFacing() == 4) {
				tempx = y1 - y1 - y1 - distance;
			}
			if (this.getFacing() == 5) {
				tempx = y1 + distance;
			}
			
			shape.add(xCoord + tempx, yCoord + tempy, zCoord + tempz);
		}
	}

	@Override
	public ItemStack getStackInSlotOnClosing(int var1) {
		return null;
	}

	@Override
	public int[] getUpdate() {
		return new int[] {length, maxlength, distance, maxdistance};
	}

	@Override
	public void handleUpdate(int[] p) {
		length = p[0];
		maxlength = p[1];
		distance = p[2];
		maxdistance = p[3];
	}

	@Override
	public int estimateBlockCount() {
		return getlength();
	}
}
