package mffs;

import java.util.List;
import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.BlockGlass;
import net.minecraft.src.DamageSource;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.ModLoader;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.forge.ISpecialResistance;
import net.minecraft.src.forge.ITextureProvider;

public class BlockForceField extends BlockContainer implements ISpecialResistance {

	private boolean localFlag;
	private StringBuffer hasher = new StringBuffer();
	static int model;
	
	public static final int META_NORMAL = 0;
	public static final int META_ZAPPER = 1;
	public static final int META_CAMO = 2;
	public static final int META_REACTOR = 3;
	public static final int META_ZAPPER_CAMO = 4;
	
	public static boolean isZapper(int meta) {
		return meta == META_ZAPPER || meta == META_ZAPPER_CAMO;
	}
	public static boolean isCamo(int meta) {
		return meta == META_CAMO || meta == META_ZAPPER_CAMO;
	}

	public BlockForceField(int i) {
		super(i, i, Material.glass);
		setHardness(100000F);
		setResistance(6000F);
		//renderblockpass = 0;
		localFlag = false;
		setTickRandomly(true);
	}
	
	@Override
	public void updateTick(World w, int x, int y, int z, Random random) {
		FFBlock ffblock = FFWorld.get(w).get(x,y,z);
		if(ffblock == null)
			w.setBlockWithNotify(x, y, z, 0);
		else
			ffblock.refresh();
	}
	
	@Override
	public int getRenderType()
	{
		return model;
	}

    /**
     * Is this block (a) opaque and (b) a full 1m cube?  This determines whether or not to render the shared face of two
     * adjacent blocks and also whether the player can attach torches, redstone wire, etc to this block.
     */
	@Override
    public boolean isOpaqueCube()
    {
        return false;
    }

    /**
     * If this block doesn't render as an ordinary block it will return False (examples: signs, buttons, stairs, etc)
     */
	@Override
    public boolean renderAsNormalBlock()
    {
        return false;
    }

    /**
     * Return true if a player with SlikTouch can harvest this block directly, and not it's normal drops.
     */
	@Override
    protected boolean canSilkHarvest()
    {
        return false;
    }
	
	
	// @Override // client only override
    public int getRenderBlockPass()
    {
        return 1;
    }

    
	@Override
    public void onBlockRemoval(World world, int i, int j, int k) {

		if(!world.isRemote) {
			FFBlock ffblock = FFWorld.get(world).get(i,j,k);
			if (ffblock != null && ffblock.shouldBeActive()) {
				ffblock.refresh();
				FFWorld.get(world).queueRefresh(i, j, k);
			}
		}
	}

	@Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
		if (isZapper(world.getBlockMetadata(i, j, k))) {
			float f = 0.0625F;
			return AxisAlignedBB.getBoundingBoxFromPool(i + f, j + f, k + f, i + 1 - f, j + 1 - f, k + 1 - f);
		}

		return AxisAlignedBB.getBoundingBoxFromPool((float) i, j, (float) k, (float) (i + 1), (float) (j + 1), (float) (k + 1));
	}

	// @Override // client only override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
		return AxisAlignedBB.getBoundingBoxFromPool((float) i, j, (float) k, (float) (i + 1), j + 1, (float) (k + 1));
	}

	@Override
    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity) {

		if(!world.isRemote && isZapper(world.getBlockMetadata(i, j, k))) {
			if (entity instanceof EntityLiving) {
				entity.attackEntityFrom(DamageSource.generic, 5);
			}
		}
	}

	@Override
    public int quantityDropped(Random random) {
		return 0;
	}

	/* $if client$ */
	@Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
		int myx = i, myy = j, myz = k;
		switch(l) {
		case 0: myy++; break;
		case 1: myy--; break;
		case 2: myz++; break;
		case 3: myz--; break;
		case 4: myx++; break;
		case 5: myx--; break;
		}
		
		if(iblockaccess.getBlockId(i, j, k) == blockID && iblockaccess.getBlockMetadata(i, j, k) == iblockaccess.getBlockMetadata(myx, myy, myz))
			return false;
		
		return super.shouldSideBeRendered(iblockaccess, i, j, k, l);
	}
	/* $endif$ */

	@Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {

		return false;
	}

	/* $if client$ */
	static int[] useTextures = null;
	
	@Override
    public int getBlockTexture(IBlockAccess iblockaccess, int i, int j, int k, int l) {
		if(useTextures == null)
			return iblockaccess.getBlockMetadata(i, j, k);
		else
			return useTextures[l];
	}
	/* $endif$ */

	@Override
    public float getSpecialExplosionResistance(World world, int i, int j, int k, double d, double d1, double d2, Entity entity) {

		if(!world.isRemote) {
			FFBlock ffblock = FFWorld.get(world).get(i,j,k);
			if (ffblock != null && ffblock.shouldBeActive()) {
				ffblock.usePower(mod_ModularForceFieldSystem.forcefieldblockcreatemodifier);
			}
		}

		return 60000F;
	}

	// @Override // client only override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {

    	int meta = world.getBlockMetadata(i, j, k);
		if (isZapper(meta) && !isCamo(meta)) {

			double d = i + Math.random();
			double d1 = j + Math.random();
			double d2 = k + Math.random();

			world.spawnParticle("reddust", d, d1, d2, 0.0D, 0.0D, 0.0D);

		}
	}

	@Override
	public TileEntity getBlockEntity() {
		throw new UnsupportedOperationException("This shouldn't happen");
	}
	
	@Override
	public TileEntity getBlockEntity(int meta) {
		if(isCamo(meta))
			return new TileCamouflagedField();
		else
			return null;
	}

}
