/*
 * FlightWrapper (Bukkit Server Edit)
 * A compatability layer to allow multiple mods to enable flight for a player.
 * Author: Claire Semple (MachineMuse)
 * License: Public Domain
 */

package net.minecraft.server;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FlightWrapper {
	private static FlightWrapper instance;
	private Map<String, List<String>> enablers;

	// Singleton pattern
	private FlightWrapper() {
	}

	public static FlightWrapper getInstance() {
		if (instance == null) {
			instance = new FlightWrapper();
			instance.enablers = new HashMap<String, List<String>>();
		}
		return instance;
	}

	// Returns true if the enabler is added, false if it's already present.
	public boolean addEnabler(EntityHuman player, String identifier) {
		String username = player.name;
		if (enablers.containsKey(username)) {
			List<String> enablerList = enablers.get(username);
			if (enablerList.contains(identifier)) {
				return false;
			} else {
				enablerList.add(new String(identifier));
				return true;
			}
		} else {
			List<String> enablerList = new LinkedList<String>();
			enablerList.add(identifier);
			enablers.put(username, enablerList);
			return true;
		}
	}

	// Returns true if the enabler is removed, false if it's not present.
	public boolean removeEnabler(EntityHuman player, String identifier) {
		String username = player.name;
		if (enablers.containsKey(username)) {
			List<String> enablerList = enablers.get(username);
			if (enablerList.contains(identifier)) {
				enablerList.remove(identifier);
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	// Returns a list of enablers active on the player.
	public List<String> listEnablersForPlayer(EntityHuman player) {
		String username = player.name;
		if (enablers.containsKey(username)) {
			List<String> enablerList = enablers.get(username);
			return enablerList;
		}
		else
			return null;
	}

	// Updates flying state.
	public void update(List<EntityHuman> players) {
		for (EntityHuman player : players) {
			String username = player.name;
			boolean hasEnabler;
			if (enablers.get(username) != null) {
				hasEnabler = !enablers.get(username).isEmpty();
			} else {
				hasEnabler = false;
			}
			player.abilities.canFly = hasEnabler;
			if (!hasEnabler) {
				player.abilities.isFlying = false; // Stop flying if it's
													// disabled
			}
			player.updateAbilities();
		}
	}
}
