package net.melumpkins.common;

import ic2.api.CropCard;

import java.io.File;

import net.minecraft.src.*;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.Configuration;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PostInit;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;


@Mod(modid = "Melumpkins", name = "Melumpkins!", version = "0.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)
public class MelumpkinsMod {
	//Creating instances of the Block classes
	public static final Block MelumpkinBlock = new MelumpkinBlock(3333, 0).setHardness(2F).setResistance(2F).setStepSound(Block.soundWoodFootstep).setBlockName("MelumpkinPlant");
	
	//Creating instances of the Item classes
	
	@PreInit
	public void preload(FMLPreInitializationEvent event) {
		//A lot of this is code that GregoriusT sent me. Thanks Greg!
		File MelumpkinConfig = new File(event.getModConfigurationDirectory(), "Melumpkins.cfg");
		Configuration MelumpkinsConfig = new Configuration(MelumpkinConfig);
		MelumpkinsConfig.load();
		boolean mDoNotInit = (MelumpkinConfig.getAbsolutePath().contains("technic")||MelumpkinConfig.getAbsolutePath().contains("tekkit"));
		if (mDoNotInit) {
			// That the Tekkituser can see it in the Errorlog (if he knows what an Errorlog is of course)
			System.err.println("Hello, Trintus here.\nI see you obviously use Tekkit, but this Mod wont load or could even randomly cause crashes, because I hate Tekkit. I will not be changing this.\nP.S. I would've corrupted all your Savefiles like SirSengir, but i didn't because GregoriusT didn't send me code to do that.");
			// Just a Joke inside the newly generated Config :D
			MelumpkinsConfig.getOrCreateBooleanProperty("Tekkitsupport", "Switching this wont help", false);
			MelumpkinsConfig.save();
			return;
		}
	}
	@Init
	public void load(FMLInitializationEvent event){
		//Registering Blocks
		GameRegistry.registerBlock(MelumpkinBlock);
		
		//Setting Textures
		MinecraftForgeClient.preloadTexture("/Melumpkins/Blocks.png");
		MinecraftForgeClient.preloadTexture("/Melumpkins/Items.png");
		
		//Setting Names
		LanguageRegistry.addName(MelumpkinBlock, "Melumpkin");
		
		//Adding Recipes
	}
	@PostInit
	public void postload(FMLPostInitializationEvent event){
		//Registering IC2 Crops
		if (!CropCard.registerCrop(new MelumpkinIC2Crop(), 5817)) {
			throw new RuntimeException("I couldn't register my melumpkins!");
		}
	}
}
