package net.melumpkins.common;

import net.minecraft.src.Block;
import net.minecraft.src.ItemStack;
import ic2.api.CropCard;
import ic2.api.TECrop;

public class MelumpkinIC2Crop extends CropCard {

	//All of this code (minus some minor edits) is Drashian's. Thanks, Drashian!
	
	@Override
	public String name() {
		return "Melumpkin";
	}

	@Override
	public String discoveredBy() {
		return "Trintus";
	}

	@Override
	public int tier() {
		return 2; // Same as melons
	}

	@Override
	public int stat(int n) {
		switch (n) {
		case 0: return 0; // Not chemical
		case 1: return 3; // Melons are edible
		case 2: return 0; // No defensive properties
		case 3: return 2; // Pumpkins are primarily decorative
		case 4: return 0; // Not particularly weed-like
		default: return 0;
		}
	}

	@Override
	public String[] attributes() {
		return new String[] {"Green", "Orange", "Food", "Decoration", "Stem"}; // Melons *and* pumpkins
	}

	@Override
	public int getSpriteIndex(TECrop crop) {
		// Special handling for harvestable melumpkins
		if (crop.size == 4) {
			int harvest = checkMelumpkinHarvest(crop);
			if (harvest == 1) {
				return 19; // Sprouted pumpkins
			} else if (harvest == 2) {
				return 20; // Sprouted melons
			}
		}
		return crop.size+15; // Otherwise, use the shared pumpkin/melon stem sprite
	}

	@Override
	public boolean canGrow(TECrop crop) {
		return crop.size <= 3; // Can always grow, unless it's already harvestable
	}

	@Override
	public int weightInfluences(TECrop crop, float humidity, float nutrients, float air) {
		// Like melons and pumpkins, melumpkins require slightly more humidity and slightly less nutrients to grow
		return (int) (humidity*1.1+nutrients*0.9+air);
	}

	@Override
	public int growthDuration(TECrop crop) {
		if (crop.size == 3) return 650; // Takes a while for stems to sprout fruit
		return 225; // Stems grow pretty fast though
	}

	@Override
	public boolean canBeHarvested(TECrop crop) {
		return crop.size == 4;
	}

	@Override
	public ItemStack getGain(TECrop crop) {
		// Check to see what it grew
		int harvest = checkMelumpkinHarvest(crop);
		if (harvest == 1 || harvest == 2) {
			return new ItemStack(MelumpkinsMod.MelumpkinBlock); // Sprouted pumpkins
		} else {
			return null; // Shouldn't happen
		}
	}

	@Override
	public byte getSizeAfterHarvest(TECrop crop) {
		// getSizeAfterHarvest should really be a purely informational function
		// without side effects, but I don't see any other 'after harvest' hook,
		// so resetMelumpkinHarvest goes here for now.
		resetMelumpkinHarvest(crop);
		return 3; // Returns to fully-grown stem size
	}

	/**
	 * Checks what the melumpkin plant has sprouted. If it hasn't been decided yet,
	 * this is where that happens.
	 * @param crop TECrop to check on
	 * @return 1 for pumpkins, 2 for melons
	 */
	public int checkMelumpkinHarvest(TECrop crop) {
		if (crop.custumData[0] == 0) {
			// Hasn't decided what sprouted yet, time to do that
			// 50/50 chance of sprouting pumpkins (1) or melons (2)
			crop.custumData[0] = (short) (crop.worldObj.rand.nextInt(1)+1);
		}
		return crop.custumData[0];
	}

	/**
	 * Resets the harvest type of a melumpkin plant, so that the next call to
	 * checkMelumpkinHarvest picks a new value.
	 * @param crop TECrop to reset
	 */
	public void resetMelumpkinHarvest(TECrop crop) {
		crop.custumData[0] = 0; // Set harvest type back to 0 (undecided) so a different type can be picked next time
	}

}