package net.minecraft.src;

import java.io.File;
import java.text.DecimalFormat;
import java.lang.Math;

import java.util.Arrays;
import java.util.TreeMap;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

import net.minecraft.client.Minecraft;
import net.minecraftforge.common.*;
import ic2.common.*;
import ic2.api.*;


//TODO (in decreasing priority order):
// -Remove the Modloader structures and alter to pure FML (so: no BaseMod, KeyBindings are different, probably other stuff too)
// --this isn't too important, since it turns out that you can still call ModLoader functions
// -Move ArmourHUD into its own package - right now, it's in net.minecraft.src, which is probably bad practice
// -Add in functions so that item creators can control the status display themselves
// --this will be achieved by checking for the presence of wrapper functions in the armour and active tool item classes, then calling them to obtain the prefix and postfix text and colour, along with whether the damage level should be displayed
// --instead of checking for functions within a particular class, perhaps provide an interface which modders can include and compile against that offers all the requisite functions - then you can just do an instanceof check and skip that horrible reflection stuff
// --another useful function here is for modders to say whether their helmets provide a HUD, then I don't need to check for special cases manually
// -make it so that items can display prefixes and postfixes only when you have a HUD helmet on (eg. target co-ordinates for a freqtrans)

public class mod_ArmourHUD extends BaseMod
{
  
  private KeyBinding HUD_position_button = new KeyBinding("HUD_position_button", 210);
  // old default = 35 = H
  // new default = 210 = insert
  
  
  public boolean has_HUD_helmet = false;
  public boolean has_advanced_HUD_helmet = false;
  // set to true if you've got a helmet on which would be able to display a HUD
  // this is the nanosuit helmet, quantum suit helmet
  // and the future diagnostic hat
  
  // advanced helmet will display the actual energy content/durability remaining
  // instead of a crappy percentage
  // perhaps later versions will even show remaining flight time explicitly?
  
  
  // if an item is active, its schematic component will be given a thick white border
  
  public boolean hat_active = false;
  public boolean shirt_active = false;
  public boolean trousers_active = false;
  public boolean shoes_active = false;
  public boolean tool_active = false;
  
  
  public String hat_name = "";
  public String shirt_name = "";
  public String trousers_name = "";
  public String shoes_name = "";
  public String tool_name = "";
  
  
  public String hat_value = "";
  public String shirt_value = "";
  public String trousers_value = "";
  public String shoes_value = "";
  public String tool_value = "";
  
  
  public String hat_postfix = "";
  public String shirt_postfix = "";
  public String trousers_postfix = "";
  public String shoes_postfix = "";
  public String tool_postfix = "";
  
  
  public String hat_prefix = "";
  public String shirt_prefix = "";
  public String trousers_prefix = "";
  public String shoes_prefix = "";
  public String tool_prefix = "";
  
  
  public float hat_prefix_hue = 240.0F;
  public float shirt_prefix_hue = 240.0F;
  public float trousers_prefix_hue = 240.0F;
  public float shoes_prefix_hue = 240.0F;
  public float tool_prefix_hue = 240.0F;
  
  public float hat_prefix_saturation = 0.0F;
  public float shirt_prefix_saturation = 0.0F;
  public float trousers_prefix_saturation = 0.0F;
  public float shoes_prefix_saturation = 0.0F;
  public float tool_prefix_saturation = 0.0F;
  
  public float hat_prefix_luminosity = 1.0F;
  public float shirt_prefix_luminosity = 1.0F;
  public float trousers_prefix_luminosity = 1.0F;
  public float shoes_prefix_luminosity = 1.0F;
  public float tool_prefix_luminosity = 1.0F;
  
  
  public float hat_postfix_hue = 240.0F;
  public float shirt_postfix_hue = 240.0F;
  public float trousers_postfix_hue = 240.0F;
  public float shoes_postfix_hue = 240.0F;
  public float tool_postfix_hue = 240.0F;
  
  public float hat_postfix_saturation = 0.0F;
  public float shirt_postfix_saturation = 0.0F;
  public float trousers_postfix_saturation = 0.0F;
  public float shoes_postfix_saturation = 0.0F;
  public float tool_postfix_saturation = 0.0F;
  
  public float hat_postfix_luminosity = 1.0F;
  public float shirt_postfix_luminosity = 1.0F;
  public float trousers_postfix_luminosity = 1.0F;
  public float shoes_postfix_luminosity = 1.0F;
  public float tool_postfix_luminosity = 1.0F;
  
  
  
  private float hat_string_width = 0.0F;
  private float shirt_string_width = 0.0F;
  private float trousers_string_width = 0.0F;
  private float shoes_string_width = 0.0F;
  private float tool_string_width = 0.0F;
  
  
  DecimalFormat armour_percent = new DecimalFormat("###.#");
  
  DecimalFormat coarse_armour_percent = new DecimalFormat("###");
  
  // these variables are accessed from both multiple functions
  // and I don't like passing them as parameters
  ItemStack hat;
  ItemStack shirt;
  ItemStack trousers;
  ItemStack shoes;
  ItemStack tool;
  
  
  int hat_charge;
  int shirt_charge;
  int trousers_charge;
  int shoes_charge;
  int tool_charge;
  
  int hat_max_charge;
  int shirt_max_charge;
  int trousers_max_charge;
  int shoes_max_charge;
  int tool_max_charge;
  
  // we'll work out the basic fractional charge/durability remaining in a separate function
  // it'll be easier to re-use them for all the calculations I'll need to do
  float hat_fraction;
  float shirt_fraction;
  float trousers_fraction;
  float shoes_fraction;
  float tool_fraction;
  
  
  private static int disp_width;
  private static int disp_height;
  
  private float x_offset;
  private float y_offset;
  
  private float armour_x_centre;
  
  private float armour_width;
  private float armour_height;
  
  private float bodypart_spacing;
  // spacing between head and torso, torso and arms, torso and legs, legs and shoes
  
  private float border_spacing;
  // distance between top/bottom of armour figure and top/bottom of background
  
  private float head_width;
  // head will be automatically centred and is square
  // parameter here is vertical spacing between head and torso
  
  private float torso_width;
  private float torso_height;
  private float torso_ypos;
  // torso will be automatically centred
  
  private float arm_width;
  private float arm_height;
  // arms start level with the top of the torso
  // the only parameter is the spacing between the arm and the torso
  // arms will automatically be generated as a pair
  
  private float leg_width;
  private float leg_height;
  // likewise, legs start level with the torso's outer vertical edges
  // legs will be generated as a pair
  private float left_leg_xcentre;
  private float right_leg_xcentre;
  
  
  private float shoe_width;
  private float shoe_height;
  private float shoe_ypos;
  // we'll store the shoe ypos, since we'd have to evaluate it twice otherwise
  // saves minutely on execution time?
  // don't need xpos - shoes centre on the legs
  
  private float box_border_spacing = 2.0F;
  private float box_alpha = 0.3F;
  private float armour_alpha = 0.6F;
  
  private float graphical_text_scaling;
  private float graphical_text_alpha = 0.9F;
  private float graphical_text_xpos;
  private float graphical_text_ypos;
  
  private float space_char_width = 0.0F;
  
  
  
  public String getVersion()
  {
    return "2.4 [MC r1.3.2]";
  }
  
  /*
  public String getPriorities()
  {
    return "after:mod_IC2";
  }
  */
  
  // copying verbatim from the config file tutorial on the Minecraft Forge website...
  static Configuration armour_HUD_config = new Configuration(new File(Minecraft.getMinecraftDir(), "config/ArmourHUD.cfg"));
  
  public static boolean show_schematic;
  public static boolean show_text;
  public static boolean always_percentages;
  public static float HUD_size_percentage;
  public static float HUD_text_percentage;
  public static float HUD_colour_saturation;
  public static float HUD_maximum_hue;
  
  
  
  public static int configurationProperties()
  {
    armour_HUD_config.load();
    HUD_position = Integer.parseInt(armour_HUD_config.get(Configuration.CATEGORY_GENERAL, "HUD Position", 1).value);
    
    // ok, I can't figure out how to put comments in the config file
    // and the Minecraft Forge website/forum is completely useless
    // so we'll have to trust in the readme...
    
    // HUD position code: 0 = top-left, 1 = top-right, 2 = bottom-left, 3 = bottom-right, 4 = off
    // while I personally prefer it in the bottom left
    // Thaumcraft's Goggles also sit there and I don't know if you can move them
    // so top-right it is
    
    if(HUD_position < 0 || HUD_position > 4)
      HUD_position = 1;
    // no, bad user...
      
      
      show_schematic = Boolean.parseBoolean(armour_HUD_config.get(Configuration.CATEGORY_GENERAL, "Show HUD Schematic", false).value);
      
      show_text = Boolean.parseBoolean(armour_HUD_config.get(Configuration.CATEGORY_GENERAL, "Show HUD Text", true).value);
      
      always_percentages = Boolean.parseBoolean(armour_HUD_config.get(Configuration.CATEGORY_GENERAL, "Use Percentages instead of exact values", false).value);
      
      
      // legal values: 1-150
      // default: 50
      HUD_text_percentage = (float)Integer.parseInt(armour_HUD_config.get(Configuration.CATEGORY_GENERAL, "HUD Text Size Percentage", 50).value) / 100.0F;
      
      if(HUD_text_percentage < 0.01F || HUD_text_percentage > 1.5F)
	HUD_text_percentage = 0.65F;
      
      
      // legal values: 1-150
      // default: 60
	HUD_size_percentage = (float)Integer.parseInt(armour_HUD_config.get(Configuration.CATEGORY_GENERAL, "HUD Graphics Size Percentage", 60).value) / 100.0F;
      
      if(HUD_size_percentage < 0.01F || HUD_size_percentage > 1.5F)
	HUD_size_percentage = 1.0F;
      
      // legal values: 1-100
      // default: 70
	HUD_colour_saturation = (float)Integer.parseInt(armour_HUD_config.get(Configuration.CATEGORY_GENERAL, "HUD Colour Saturation", 70).value) / 100.0F;
      
      if(HUD_colour_saturation < 0.0F || HUD_colour_saturation > 1.0F)
	HUD_colour_saturation = 1.0F;
      
      // legal values: 1-360
      // default: 240
	HUD_maximum_hue = (float)Integer.parseInt(armour_HUD_config.get(Configuration.CATEGORY_GENERAL, "HUD Maximum Hue", 240).value);
	
      if(HUD_maximum_hue < 1.0F || HUD_maximum_hue > 360.0F)
	HUD_maximum_hue = 240.0F;
      
      armour_HUD_config.save();
      
      return(HUD_position);
  }
  
  
  public static int HUD_position = configurationProperties();;
  // 0 = top-left, 1 = top-right, 2 = bottom-left, 3 = bottom-right, 4 = disabled
  
  
  public TreeMap<String, String> item_abbreviations = new TreeMap<String, String>();
  
  
  
  // static Configuration item_abbreviation_file = new Configuration(new File(Minecraft.getMinecraftDir(), "config/ItemAbbreviations.cfg"));
  
  public static String loadAbbreviatedItemName(String item_name)
  {
	// I take it forge derps when encountering non-alphanumeric/whitespace characters?
    for(int i = 0; i < item_name.length(); i++)
    {
      if((!Character.isLetterOrDigit(item_name.charAt(i)) && !Character.isWhitespace(item_name.charAt(i))) || item_name.charAt(i) > 255)
      {
	// it won't give a name for unicode objects
	// but it won't crash either...
	return item_name;
      }
    }
    // If name is null, attempt to pull configured name out of config. Otherwise supply hardcoded string.
    if(item_name == null || item_name == "" || item_name.isEmpty())
    {
      return "Unknown";
    }
    // If name !null, load par norm.
    else
    {
      armour_HUD_config.load();
      String CATEGORY_ABBREVIATIONS = "abbreviations";
      String temp_item_abbreviation = armour_HUD_config.get(CATEGORY_ABBREVIATIONS, item_name, item_name).value;
      armour_HUD_config.save();
      return temp_item_abbreviation;
    }
  }
  
  //private KeyBinding HUD_position_button;
  //private boolean is_position_button_pressed;
  
  public void load()
  {
    ModLoader.registerKey(this, this.HUD_position_button, false);
    ModLoader.addLocalization("HUD_position_button", "Status HUD Location");
    
    // we want the onTickInGame function to trigger
    ModLoader.setInGameHook(this, true, false);
    
    space_char_width = FruitDisplayLib.getStringWidth(" ") * graphical_text_scaling;
    
    System.out.println("Armour HUD Status v" + getVersion() + " loaded.");
  }
  
  
  public void keyboardEvent(KeyBinding event)
  {
    if(event == this.HUD_position_button)
    {
      
      if(!ModLoader.getMinecraftInstance().isDebugInfoEnabled() && ModLoader.getMinecraftInstance().isGuiEnabled() && ModLoader.getMinecraftInstance().inGameHasFocus)
      {
	if(HUD_position == 0)
	{
	  HUD_position = 1;
	}
	else if(HUD_position == 1)
	{
	  HUD_position = 2;
	}
	else if(HUD_position == 2)
	{
	  HUD_position = 3;
	}
	else if(HUD_position == 3)
	{
	  HUD_position = 4;
	}
	else
	{
	  HUD_position = 0;
	}
	
	armour_HUD_config.load();
	
	Property HUD_pos_prop = armour_HUD_config.get(Configuration.CATEGORY_GENERAL, "HUD Position", 1);
	
	HUD_pos_prop.value = Integer.toString(HUD_position);
	armour_HUD_config.save();
	
      }
      
    }
  }
  
  
  public String tenPercentRounding(float input)
  {
    // when given an input from 0 to 100, it will round upwards to the nearest 10%
    // if outside the bounds, returns "ERR"
    if(input > 90.0F && input <= 100.0F)
    {
      return "100";
    }
    else if(input > 80.0F && input <= 90.0F)
    {
      return "90";
    }
    else if(input > 70.0F && input <= 80.0F)
    {
      return "80";
    }
    else if(input > 60.0F && input <= 70.0F)
    {
      return "70";
    }
    else if(input > 50.0F && input <= 60.0F)
    {
      return "60";
    }
    else if(input > 40.0F && input <= 50.0F)
    {
      return "50";
    }
    else if(input > 30.0F && input <= 40.0F)
    {
      return "40";
    }
    else if(input > 20.0F && input <= 30.0F)
    {
      return "30";
    }
    else if(input > 10.0F && input <= 20.0F)
    {
      return "20";
    }
    else if(input > 0.0F && input <= 10.0F)
    {
      return "10";
    }
    else if(input == 0.0F)
    {
      return "0";
    }
    else
    {
      return "ERR";
    }
    
  }
  
  /*
  public String chargeLevelFormatting(int charge)
  {
    
  }
  */
  
  public void gearFractions()
  {
    if(hat != null && hat.getItem() instanceof IElectricItem)
    {
      IElectricItem temp_hat = (IElectricItem)hat.getItem();
      
      if(hat.stackTagCompound != null && hat.stackTagCompound.hasKey("charge"))
      {
	hat_charge = hat.stackTagCompound.getInteger("charge");
      }
      else
      {
	hat_charge = 0;
	hat_fraction = 0.0F;
      }
      
      hat_max_charge = temp_hat.getMaxCharge();
      
      if(hat_charge == 0)
      {
	hat_fraction = 0.0F;
	// without this particular bit of code, we get ERR% on the status readout
	// and the "item depleted" code to colour it black doesn't trigger
	// I could move it up and compact the code
	// but that would mean adding even more code to set the fraction to zero
      }
      else
      {
	hat_fraction = (float)hat_charge / (float)hat_max_charge;
      }
      
    }
    else if(hat != null)
    {
      hat_fraction = (float)(hat.getMaxDamage() - hat.getItemDamage()) / (float)hat.getMaxDamage();
    }
    else
    {
      hat_fraction = 0.0F;
    }
    
    
    if(shirt != null && shirt.getItem() instanceof IElectricItem)
    {
      IElectricItem temp_shirt = (IElectricItem)shirt.getItem();
      
      if(shirt.stackTagCompound != null && shirt.stackTagCompound.hasKey("charge"))
      {
	shirt_charge = shirt.stackTagCompound.getInteger("charge");
      }
      else
      {
	shirt_charge = 0;
      }
      
      shirt_max_charge = temp_shirt.getMaxCharge();
      
      if(shirt_charge == 0)
      {
	shirt_fraction = 0.0F;
      }
      else
      {
	shirt_fraction = (float)shirt_charge / (float)shirt_max_charge;
      }
      
    }
    else if(shirt != null)
    {
      shirt_fraction = (float)(shirt.getMaxDamage() - shirt.getItemDamage()) / (float)shirt.getMaxDamage();
    }
    else
    {
      shirt_fraction = 0.0F;
    }
    
    
    if(trousers != null && trousers.getItem() instanceof IElectricItem)
    {
      IElectricItem temp_trousers = (IElectricItem)trousers.getItem();
      
      if(trousers.stackTagCompound != null && trousers.stackTagCompound.hasKey("charge"))
      {
	trousers_charge = trousers.stackTagCompound.getInteger("charge");
      }
      else
      {
	trousers_charge = 0;
      }
      
      trousers_max_charge = temp_trousers.getMaxCharge();
      
      if(trousers_charge == 0)
      {
	trousers_fraction = 0.0F;
      }
      else
      {
	trousers_fraction = (float)trousers_charge / (float)trousers_max_charge;
      }
      
    }
    else if(trousers != null)
    {
      trousers_fraction = (float)(trousers.getMaxDamage() - trousers.getItemDamage()) / (float)trousers.getMaxDamage();
    }
    else
    {
      trousers_fraction = 0.0F;
    }
    
    
    if(shoes != null && shoes.getItem() instanceof IElectricItem)
    {
      IElectricItem temp_shoes = (IElectricItem)shoes.getItem();
      
      if(shoes.stackTagCompound != null && shoes.stackTagCompound.hasKey("charge"))
      {
	shoes_charge = shoes.stackTagCompound.getInteger("charge");
      }
      else
      {
	shoes_charge = 0;
      }
      
      shoes_max_charge = temp_shoes.getMaxCharge();
      
      if(shoes_charge == 0)
      {
	shoes_fraction = 0.0F;
      }
      else
      {
	shoes_fraction = (float)shoes_charge / (float)shoes_max_charge;
      }
      
    }
    else if(shoes != null)
    {
      shoes_fraction = (float)(shoes.getMaxDamage() - shoes.getItemDamage()) / (float)shoes.getMaxDamage();
    }
    else
    {
      shoes_fraction = 0.0F;
    }
    
    
    if(tool != null && tool.getItem() instanceof IElectricItem)
    {
      
      IElectricItem temp_tool = (IElectricItem)tool.getItem();
      
      if(tool.stackTagCompound != null && tool.stackTagCompound.hasKey("charge"))
      {
	tool_charge = tool.stackTagCompound.getInteger("charge");
      }
      else
      {
	tool_charge = 0;
      }
      
      tool_max_charge = temp_tool.getMaxCharge();
      
      if(tool_charge == 0)
      {
	tool_fraction = 0.0F;
      }
      else
      {
	tool_fraction = (float)tool_charge / (float)tool_max_charge;
      }
    }
    else if(tool != null && !(tool.getItem() instanceof IElectricItem) && tool.getItem().isDamageable())
    {
      tool_fraction = (float)(tool.getMaxDamage() - tool.getItemDamage()) / (float)tool.getMaxDamage();
    }
    else if(tool != null)
    {
      tool_fraction = 2.0F;
    }
    else
    {
      tool_fraction = 0.0F;
    }
  }
  
  public void gearWords()
  {
    
    if(hat != null)
    {
      hat_name = hat.getItemName() + "";
      
      if(hat_name == null || hat_name == "")
      {
	hat_name = "Unknown";
      }
      else if(item_abbreviations.containsKey(hat_name))
      {
	hat_name = item_abbreviations.get(hat_name);
      }
      else
      {
	item_abbreviations.put(hat_name, loadAbbreviatedItemName(hat_name));
      }
    }
    
    
    if(hat != null && hat.getItem() instanceof IElectricItem && has_advanced_HUD_helmet && !always_percentages)
    {
      // we do things like this so that the colon isn't coloured
      hat_name = hat_name + ": ";
      hat_value = Integer.toString(hat_charge) + "/" + Integer.toString(hat_max_charge) + " EU";
    }
    else if(hat != null && has_advanced_HUD_helmet && !always_percentages)
    {
      hat_name = hat_name + ": ";
      hat_value = Integer.toString(hat.getMaxDamage() - hat.getItemDamage()) + "/" + Integer.toString(hat.getMaxDamage());
    }
    else if(hat != null && hat.getItem().isDamageable())
    {
      hat_name = hat_name + ": ";
      // hat_value = (has_HUD_helmet ? armour_percent.format(hat_fraction * 100.0F) : tenPercentRounding(hat_fraction * 100.0F)) + "%";
      hat_value = (has_HUD_helmet ? armour_percent.format(hat_fraction * 100.0F) : coarse_armour_percent.format(hat_fraction * 100.0F)) + "%";
    }
    else
    {
      hat_value = "";
    }
    
    
    
    if(shirt != null)
    {
      shirt_name = shirt.getItemName() + "";
      
      if(shirt_name == null || shirt_name == "")
      {
	shirt_name = "Unknown";
      }
      else if(item_abbreviations.containsKey(shirt_name))
      {
	shirt_name = item_abbreviations.get(shirt_name);
      }
      else
      {
	item_abbreviations.put(shirt_name, loadAbbreviatedItemName(shirt_name));
      }
    }
    
    if(shirt != null && shirt.getItem() instanceof IElectricItem && has_advanced_HUD_helmet && !always_percentages)
    {
      shirt_name = shirt_name + ": ";
      shirt_value = Integer.toString(shirt_charge) + "/" + Integer.toString(shirt_max_charge) + " EU";
    }
    else if(shirt != null && has_advanced_HUD_helmet && !always_percentages)
    {
      shirt_name = shirt_name + ": ";
      shirt_value = Integer.toString(shirt.getMaxDamage() - shirt.getItemDamage()) + "/" + Integer.toString(shirt.getMaxDamage());
    }
    else if(shirt != null && shirt.getItem().isDamageable())
    {
      shirt_name = shirt_name + ": ";
      // shirt_value = (has_HUD_helmet ? armour_percent.format(shirt_fraction * 100.0F) : tenPercentRounding(shirt_fraction * 100.0F)) + "%";
      shirt_value = (has_HUD_helmet ? armour_percent.format(shirt_fraction * 100.0F) : coarse_armour_percent.format(shirt_fraction * 100.0F)) + "%";
    }
    else
    {
      shirt_value = "";
    }
    
    
    if(trousers != null)
    {
      trousers_name = trousers.getItemName() + "";
      
      if(trousers_name == null || trousers_name == "")
      {
	trousers_name = "Unknown";
      }
      else if(item_abbreviations.containsKey(trousers_name))
      {
	trousers_name = item_abbreviations.get(trousers_name);
      }
      else
      {
	item_abbreviations.put(trousers_name, loadAbbreviatedItemName(trousers_name));
      }
    }
    
    if(trousers != null && trousers.getItem() instanceof IElectricItem && has_advanced_HUD_helmet && !always_percentages)
    {
      trousers_name = trousers_name + ": ";
      trousers_value = Integer.toString(trousers_charge) + "/" + Integer.toString(trousers_max_charge) + " EU";
    }
    else if(trousers != null && has_advanced_HUD_helmet && !always_percentages)
    {
      trousers_name = trousers_name + ": ";
      trousers_value = Integer.toString(trousers.getMaxDamage() - trousers.getItemDamage()) + "/" + Integer.toString(trousers.getMaxDamage());
    }
    else if(trousers != null && trousers.getItem().isDamageable())
    {
      trousers_name = trousers_name + ": ";
      // trousers_value = (has_HUD_helmet ? armour_percent.format(trousers_fraction * 100.0F) : tenPercentRounding(trousers_fraction * 100.0F)) + "%";
      trousers_value = (has_HUD_helmet ? armour_percent.format(trousers_fraction * 100.0F) : coarse_armour_percent.format(trousers_fraction * 100.0F)) + "%";
    }
    else
    {
      trousers_value = "";
    }
    
    
    if(shoes != null)
    {
      shoes_name = shoes.getItemName() + "";
      
      if(shoes_name == null || shoes_name == "")
      {
	shoes_name = "Unknown";
      }
      else if(item_abbreviations.containsKey(shoes_name))
      {
	shoes_name = item_abbreviations.get(shoes_name);
      }
      else
      {
	item_abbreviations.put(shoes_name, loadAbbreviatedItemName(shoes_name));
      }
    }
    
    if(shoes != null && shoes.getItem() instanceof IElectricItem && has_advanced_HUD_helmet && !always_percentages)
    {
      shoes_name = shoes_name + ": ";
      shoes_value = Integer.toString(shoes_charge) + "/" + Integer.toString(shoes_max_charge) + " EU";
    }
    else if(shoes != null && has_advanced_HUD_helmet && !always_percentages)
    {
      shoes_name = shoes_name + ": ";
      shoes_value = Integer.toString(shoes.getMaxDamage() - shoes.getItemDamage()) + "/" + Integer.toString(shoes.getMaxDamage());
    }
    else if(shoes != null && shoes.getItem().isDamageable())
    {
      shoes_name = shoes_name + ": ";
      // shoes_value = (has_HUD_helmet ? armour_percent.format(shoes_fraction * 100.0F) : tenPercentRounding(shoes_fraction * 100.0F)) + "%";
      shoes_value = (has_HUD_helmet ? armour_percent.format(shoes_fraction * 100.0F) : coarse_armour_percent.format(shoes_fraction * 100.0F)) + "%";
    }
    else
    {
      shoes_value = "";
    }
    
    
    if(tool != null)
    {
      tool_name = tool.getItemName() + "";
      
      if(tool_name == null || tool_name == "")
      {
	tool_name = "Unknown";
      }
      else if(item_abbreviations.containsKey(tool_name))
      {
	tool_name = item_abbreviations.get(tool_name);
      }
      else
      {
	item_abbreviations.put(tool_name, loadAbbreviatedItemName(tool_name));
      }
    }
    
    if(tool != null && tool.getItem() instanceof IElectricItem && has_advanced_HUD_helmet && !always_percentages)
    {
      tool_name = tool_name + ": ";
      tool_value = Integer.toString(tool_charge) + "/" + Integer.toString(tool_max_charge) + " EU";
    }
    else if(tool != null && tool.getItem() instanceof IElectricItem && has_HUD_helmet)
    {
      tool_name = tool_name + ": ";
      tool_value = armour_percent.format(tool_fraction * 100.0F) + "%";
    }
    else if(tool != null && tool.getItem() instanceof IElectricItem)
    {
      tool_name = tool_name + ": ";
      // tool_value = tenPercentRounding(tool_fraction * 100.0F) + "%";
      tool_value = coarse_armour_percent.format(tool_fraction * 100.0F) + "%";
    }
    // in here should go some code to display the remaining damage for a non-electric item
    // then we can finally do away with Tooltip...
    else if(tool != null && tool.getItem().isDamageable() && has_advanced_HUD_helmet && !always_percentages)
    {
      tool_name = tool_name + ": ";
      tool_value = Integer.toString(tool.getMaxDamage() - tool.getItemDamage()) + "/" + Integer.toString(tool.getMaxDamage());
    }
    else if(tool != null && tool.getItem().isDamageable() && has_HUD_helmet)
    {
      tool_name = tool_name + ": ";
      tool_value = armour_percent.format(tool_fraction * 100.0F) + "%";
    }
    else if(tool != null && tool.getItem().isDamageable())
    {
      tool_name = tool_name + ": ";
      // tool_value = tenPercentRounding(tool_fraction * 100.0F) + "%";
      tool_value = coarse_armour_percent.format(tool_fraction * 100.0F) + "%";
    }
    else if(tool != null && tool.getItem().getItemStackLimit() > 1)
    {
      tool_prefix = Integer.toString(tool.stackSize) + "x ";
      // need to erase the value for the tool if we use a stack item
      // otherwise it just shows up as normal
      tool_value = "";
    }
    else if(tool != null)
    {
      tool_value = "";
      // the compiler throws a wobbly if you don't stick that empty string on the end
      // complaining about not being given a String, but an Object instead
      // yes, it is an Object. In fact, it's a subclass of an Object
      // it's called a String... you idiot
      
      // I pondered not displaying this at all if you don't have a HUD helmet equipped
      // since you can get 1 in 10 precision from the quick bar icon anyway
      // however, it's sometimes nice to see what you've got equipped
    }
    else
    {
      tool_value = "";
    }
  }
  
  
  public void graphicalStatus(Minecraft minecraft)
  {
    if(show_schematic && has_HUD_helmet)
    {
      // background for armour status panel
      FruitDisplayLib.drawShadedRect(x_offset, y_offset, armour_width, armour_height, FruitDisplayLib.HSVtoRGB(0.0F, 0.0F, 0.0F), box_alpha);
    }
    
    if(hat != null)
    {
      
      if(show_schematic && has_HUD_helmet)
      {
	// draw the head
	// head ypos = torso ypos - bodypart_spacing - head_width
	// head xpos = armour_x_centre - (head_width / 2.0F)
	FruitDisplayLib.drawShadedRect(armour_x_centre - (head_width / 2.0F), torso_ypos - bodypart_spacing - head_width, head_width, head_width, FruitDisplayLib.HSVtoRGB(hat_fraction * HUD_maximum_hue, 1.0F, 1.0F), armour_alpha);
	
	if(hat_active)
	{
	  FruitDisplayLib.drawHollowRect(armour_x_centre - (head_width / 2.0F), torso_ypos - bodypart_spacing - head_width, head_width, head_width, 2.0F, FruitDisplayLib.HSVtoRGB(1.0F, 0.0F, 1.0F), armour_alpha);
	}
	
      }
      
      if(HUD_position == 0)
      {
	graphical_text_xpos = box_border_spacing + armour_width + armour_width / 4.0F;
	graphical_text_ypos = y_offset;
      }
      else if(HUD_position == 1)
      {
	graphical_text_xpos = (float)disp_width - box_border_spacing - armour_width - armour_width / 4.0F - hat_string_width;
	graphical_text_ypos = y_offset;
      }
      else if(HUD_position == 2)
      {
	graphical_text_xpos = box_border_spacing;
	graphical_text_ypos = y_offset - 30.0F * graphical_text_scaling;
      }
      else
      {
	graphical_text_xpos = (float)disp_width - box_border_spacing - hat_string_width;
	graphical_text_ypos = y_offset - 30.0F * graphical_text_scaling;
      }
      
      if(show_text)
      {
	// background for the text - makes it easier to see
	FruitDisplayLib.drawShadedRect(graphical_text_xpos - 1.0F * graphical_text_scaling, graphical_text_ypos - 1.0F * graphical_text_scaling, hat_string_width + 2.0F * graphical_text_scaling, 10.0F * graphical_text_scaling, FruitDisplayLib.HSVtoRGB(0.0F, 0.0F, 0.0F), box_alpha);
	
	// ATTACK OF THE MUTANT KILLER FUDGE FACTOR FROM SPACE!!1
	
	
	FruitDisplayLib.renderScaledStringAtPos(hat_prefix, graphical_text_xpos, graphical_text_ypos, graphical_text_scaling, FruitDisplayLib.HSVtoRGB(hat_prefix_hue, hat_prefix_saturation, hat_prefix_luminosity), graphical_text_alpha, false);
	
	FruitDisplayLib.renderScaledStringAtPos(hat_name, graphical_text_xpos + FruitDisplayLib.getStringWidth(hat_prefix) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, FruitDisplayLib.HSVtoRGB(HUD_maximum_hue, 0.0F, 1.0F), graphical_text_alpha, false);
	
	FruitDisplayLib.renderScaledStringAtPos(hat_value, graphical_text_xpos + FruitDisplayLib.getStringWidth(hat_prefix + hat_name) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, FruitDisplayLib.HSVtoRGB(hat_fraction * HUD_maximum_hue, HUD_colour_saturation * 1.0F, 1.0F), graphical_text_alpha, false);
	
	FruitDisplayLib.renderScaledStringAtPos(hat_postfix, graphical_text_xpos + FruitDisplayLib.getStringWidth(hat_prefix + hat_name + hat_value) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, FruitDisplayLib.HSVtoRGB(hat_postfix_hue, hat_postfix_saturation, hat_postfix_luminosity), graphical_text_alpha, false);
	
	// hat string is level with the top of the armour box, not the head
	// since the head icon is so small
	// when the display is on the bottom, we'll put the hat status above the box
	// so that we don't obscure the original Minecraft HUD
	
	// draw: hat_prefix + hat_name + hat_value + hat_postfix
	// only value has a colour at the moment
	// each string is responsible for adding its own spacings
	// this is so that I can have 64x(item) - it looks nicer without a space
      }
      
    }
    else
    {
      if(show_schematic && has_HUD_helmet)
      {
	FruitDisplayLib.drawHollowRect(armour_x_centre - (head_width / 2.0F), torso_ypos - bodypart_spacing - head_width, head_width, head_width, 0.5F, FruitDisplayLib.HSVtoRGB(1.0F, 0.0F, 1.0F), armour_alpha);
      }
    }
    
    if(shirt != null)
    {
      if(show_schematic && has_HUD_helmet)
      {
      // draw the torso
	FruitDisplayLib.drawShadedRect(armour_x_centre - (torso_width / 2.0F), torso_ypos, torso_width, torso_height, FruitDisplayLib.HSVtoRGB(shirt_fraction * HUD_maximum_hue, 1.0F, 1.0F), armour_alpha);
	
	
	// draw a white outline on the torso to indicate whether it's active
	if(shirt_active)
	{
	  FruitDisplayLib.drawHollowRect(armour_x_centre - (torso_width / 2.0F), torso_ypos, torso_width, torso_height, 2.0F, FruitDisplayLib.HSVtoRGB(1.0F, 0.0F, 1.0F), armour_alpha);
	}
      }
      
      
      if(HUD_position == 0)
      {
	graphical_text_xpos = box_border_spacing + armour_width + armour_width / 4.0F;
	// graphical_text_ypos = (float)torso_ypos - (float)bodypart_spacing;
	graphical_text_ypos = y_offset + 15.0F * graphical_text_scaling;
      }
      else if(HUD_position == 1)
      {
	graphical_text_xpos = (float)disp_width - box_border_spacing - armour_width - armour_width / 4.0F - shirt_string_width;
	// graphical_text_ypos = (float)torso_ypos - (float)bodypart_spacing;
	graphical_text_ypos = y_offset + 15.0F * graphical_text_scaling;
      }
      else if(HUD_position == 2)
      {
	graphical_text_xpos = box_border_spacing;
	graphical_text_ypos = y_offset - 15.0F * graphical_text_scaling;
      }
      else
      {
	graphical_text_xpos = (float)disp_width - box_border_spacing - shirt_string_width;
	graphical_text_ypos = y_offset - 15.0F * graphical_text_scaling;
      }
      
      
      if(show_text)
      {
	FruitDisplayLib.drawShadedRect(graphical_text_xpos - 1.0F * graphical_text_scaling, graphical_text_ypos - 1.0F * graphical_text_scaling, shirt_string_width + (2.0F * graphical_text_scaling), 10.0F * graphical_text_scaling, FruitDisplayLib.HSVtoRGB(0.0F, 0.0F, 0.0F), box_alpha);
	
	FruitDisplayLib.renderScaledStringAtPos(shirt_prefix, graphical_text_xpos, graphical_text_ypos, graphical_text_scaling, FruitDisplayLib.HSVtoRGB(shirt_prefix_hue, shirt_prefix_saturation, shirt_prefix_luminosity), graphical_text_alpha, false);
	
	FruitDisplayLib.renderScaledStringAtPos(shirt_name, graphical_text_xpos + FruitDisplayLib.getStringWidth(shirt_prefix) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, FruitDisplayLib.HSVtoRGB(HUD_maximum_hue, 0.0F, 1.0F), graphical_text_alpha, false);
	
	FruitDisplayLib.renderScaledStringAtPos(shirt_value, graphical_text_xpos + FruitDisplayLib.getStringWidth(shirt_prefix + shirt_name) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, FruitDisplayLib.HSVtoRGB(shirt_fraction * HUD_maximum_hue, HUD_colour_saturation * 1.0F, 1.0F), graphical_text_alpha, false);
	
	FruitDisplayLib.renderScaledStringAtPos(shirt_postfix, graphical_text_xpos + FruitDisplayLib.getStringWidth(shirt_prefix + shirt_name + shirt_value) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, FruitDisplayLib.HSVtoRGB(shirt_postfix_hue, shirt_postfix_saturation, shirt_postfix_luminosity), graphical_text_alpha, false);
	

	// shirt string is level with the head
	// since the head icon is so small
	// when the display is on the bottom, we'll put the hat status above the box
	// so that we don't obscure the original Minecraft HUD
      }
      
    }
    else
    {
      if(show_schematic && has_HUD_helmet)
      {
	FruitDisplayLib.drawHollowRect(armour_x_centre - (torso_width / 2.0F), torso_ypos, torso_width, torso_height, 0.5F, FruitDisplayLib.HSVtoRGB(1.0F, 0.0F, 1.0F), armour_alpha);
      }
    }
    
    if(trousers != null)
    {
      if(show_schematic && has_HUD_helmet)
      {
	// draw the legs
	// legs ypos = torso ypos + torso_height + bodypart_spacing
	// first leg xpos = torso xpos
	// second leg xpos = torso xpos + torso_width - leg_width
	// = armour_x_centre + (torso_width / 2.0F - leg_width
	
	// let's change things a little and have the leg centre positions stored in variables
	// since we'll be accessing them later for the shoe positions
	// leg 1:
	FruitDisplayLib.drawShadedRect(left_leg_xcentre - (leg_width / 2.0F), torso_ypos + torso_height + bodypart_spacing, leg_width, leg_height, FruitDisplayLib.HSVtoRGB(trousers_fraction * HUD_maximum_hue, 1.0F, 1.0F), armour_alpha);
	// leg 2:
	FruitDisplayLib.drawShadedRect(right_leg_xcentre - (leg_width / 2.0F), torso_ypos + torso_height + bodypart_spacing, leg_width, leg_height, FruitDisplayLib.HSVtoRGB(trousers_fraction * HUD_maximum_hue, 1.0F, 1.0F), armour_alpha);
	
	if(trousers_active)
	{
	  // leg 1:
	  FruitDisplayLib.drawHollowRect(left_leg_xcentre - (leg_width / 2.0F), torso_ypos + torso_height + bodypart_spacing, leg_width, leg_height, 2.0F, FruitDisplayLib.HSVtoRGB(1.0F, 0.0F, 1.0F), armour_alpha);
	  // leg 2:
	  FruitDisplayLib.drawHollowRect(right_leg_xcentre - (leg_width / 2.0F), torso_ypos + torso_height + bodypart_spacing, leg_width, leg_height, 2.0F, FruitDisplayLib.HSVtoRGB(1.0F, 0.0F, 1.0F), armour_alpha);
	}
	
      }
      
      
      if(HUD_position == 0)
      {
	graphical_text_xpos = box_border_spacing + armour_width + armour_width / 4.0F;
	graphical_text_ypos = y_offset + 45.0F * graphical_text_scaling;
	// 10.0F is the normal spacing between lines, so we scale it here
	// makes my life easier...
      }
      else if(HUD_position == 1)
      {
	graphical_text_xpos = (float)disp_width - box_border_spacing - armour_width - armour_width / 4.0F - trousers_string_width;
	graphical_text_ypos = y_offset + 45.0F * graphical_text_scaling;
      }
      else if(HUD_position == 2)
      {
	graphical_text_xpos = box_border_spacing + armour_width + armour_width / 4.0F;
	// graphical_text_ypos = (float)torso_ypos - (float)bodypart_spacing;
	graphical_text_ypos = y_offset + 15.0F * graphical_text_scaling;
	// using 15.0F here, so that we get more spacing
	// not vital, but it'll look just that little bit nicer
      }
      else
      {
	graphical_text_xpos = (float)disp_width - box_border_spacing - armour_width - armour_width / 4.0F - trousers_string_width;
	graphical_text_ypos = y_offset + 15.0F * graphical_text_scaling;
      }
      
      
      if(show_text)
      {
	FruitDisplayLib.drawShadedRect(graphical_text_xpos - 1.0F * graphical_text_scaling, graphical_text_ypos - 1.0F * graphical_text_scaling, trousers_string_width + 2.0F * graphical_text_scaling, 10.0F * graphical_text_scaling, FruitDisplayLib.HSVtoRGB(0.0F, 0.0F, 0.0F), box_alpha);
	
	
	FruitDisplayLib.renderScaledStringAtPos(trousers_prefix, graphical_text_xpos, graphical_text_ypos, graphical_text_scaling, FruitDisplayLib.HSVtoRGB(trousers_prefix_hue, trousers_prefix_saturation, trousers_prefix_luminosity), graphical_text_alpha, false);
	
	FruitDisplayLib.renderScaledStringAtPos(trousers_name, graphical_text_xpos + FruitDisplayLib.getStringWidth(trousers_prefix) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, FruitDisplayLib.HSVtoRGB(HUD_maximum_hue, 0.0F, 1.0F), graphical_text_alpha, false);
	
	FruitDisplayLib.renderScaledStringAtPos(trousers_value, graphical_text_xpos + FruitDisplayLib.getStringWidth(trousers_prefix + trousers_name) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, FruitDisplayLib.HSVtoRGB(trousers_fraction * HUD_maximum_hue, HUD_colour_saturation * 1.0F, 1.0F), graphical_text_alpha, false);
	
	FruitDisplayLib.renderScaledStringAtPos(trousers_postfix, graphical_text_xpos + FruitDisplayLib.getStringWidth(trousers_prefix + trousers_name + trousers_value) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, FruitDisplayLib.HSVtoRGB(trousers_postfix_hue, trousers_postfix_saturation, trousers_postfix_luminosity), graphical_text_alpha, false);
	// trousers string sits level with the hips
      }
      
    }
    else
    {
      if(show_schematic && has_HUD_helmet)
      {
	// leg 1:
	FruitDisplayLib.drawHollowRect(left_leg_xcentre - (leg_width / 2.0F), torso_ypos + torso_height + bodypart_spacing, leg_width, leg_height, 0.5F, FruitDisplayLib.HSVtoRGB(1.0F, 0.0F, 1.0F), armour_alpha);
	// leg 2:
	FruitDisplayLib.drawHollowRect(right_leg_xcentre - (leg_width / 2.0F), torso_ypos + torso_height + bodypart_spacing, leg_width, leg_height, 0.5F, FruitDisplayLib.HSVtoRGB(1.0F, 0.0F, 1.0F), armour_alpha);
      }
      
    }
    
    
    if(shoes != null)
    {
      if(show_schematic && has_HUD_helmet)
      {
	// draw the shoes
	// shoes ypos = torso ypos + torso_height + leg_height + 2 * bodypart_spacing.
	
	// shoe 1:
	FruitDisplayLib.drawShadedRect(left_leg_xcentre - (shoe_width / 2.0F), shoe_ypos, shoe_width, shoe_height, FruitDisplayLib.HSVtoRGB(shoes_fraction * HUD_maximum_hue, 1.0F, 1.0F), armour_alpha);
	// shoe 2:
	FruitDisplayLib.drawShadedRect(right_leg_xcentre - (shoe_width / 2.0F), shoe_ypos, shoe_width, shoe_height, FruitDisplayLib.HSVtoRGB(shoes_fraction * HUD_maximum_hue, 1.0F, 1.0F), armour_alpha);
	
	
	if(shoes_active)
	{
	  // shoe 1:
	  FruitDisplayLib.drawHollowRect(left_leg_xcentre - (shoe_width / 2.0F), shoe_ypos, shoe_width, shoe_height, 2.0F, FruitDisplayLib.HSVtoRGB(1.0F, 0.0F, 1.0F), armour_alpha);
	  // shoe 2:
	  FruitDisplayLib.drawHollowRect(right_leg_xcentre - (shoe_width / 2.0F), shoe_ypos, shoe_width, shoe_height, 2.0F, FruitDisplayLib.HSVtoRGB(1.0F, 0.0F, 1.0F), armour_alpha);
	}
      }
      
      
      if(HUD_position == 0)
      {
	graphical_text_xpos = box_border_spacing + armour_width + armour_width / 4.0F;
	graphical_text_ypos = y_offset + 60.0F * graphical_text_scaling;
      }
      else if(HUD_position == 1)
      {
	graphical_text_xpos = (float)disp_width - box_border_spacing - armour_width - armour_width / 4.0F - shoes_string_width;
	graphical_text_ypos = y_offset + 60.0F * graphical_text_scaling;
      }
      else if(HUD_position == 2)
      {
	graphical_text_xpos = box_border_spacing + armour_width + armour_width / 4.0F;
	// graphical_text_ypos = (float)torso_ypos - (float)bodypart_spacing;
	graphical_text_ypos = y_offset + 30.0F * graphical_text_scaling;
	// using 15.0F here, so that we get more spacing
	// not vital, but it'll look just that little bit nicer
      }
      else
      {
	graphical_text_xpos = (float)disp_width - box_border_spacing - armour_width - armour_width / 4.0F - shoes_string_width;
	graphical_text_ypos = y_offset + 30.0F * graphical_text_scaling;
      }
      
      
      if(show_text)
      {
	FruitDisplayLib.drawShadedRect(graphical_text_xpos - 1.0F * graphical_text_scaling, graphical_text_ypos - 1.0F * graphical_text_scaling, shoes_string_width + 2.0F * graphical_text_scaling, 10.0F * graphical_text_scaling, FruitDisplayLib.HSVtoRGB(0.0F, 0.0F, 0.0F), box_alpha);
	
	
	FruitDisplayLib.renderScaledStringAtPos(shoes_prefix, graphical_text_xpos, graphical_text_ypos, graphical_text_scaling, FruitDisplayLib.HSVtoRGB(shoes_prefix_hue, shoes_prefix_saturation, shoes_prefix_luminosity), graphical_text_alpha, false);
	
	FruitDisplayLib.renderScaledStringAtPos(shoes_name, graphical_text_xpos + FruitDisplayLib.getStringWidth(shoes_prefix) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, FruitDisplayLib.HSVtoRGB(HUD_maximum_hue, 0.0F, 1.0F), graphical_text_alpha, false);
	
	FruitDisplayLib.renderScaledStringAtPos(shoes_value, graphical_text_xpos + FruitDisplayLib.getStringWidth(shoes_prefix + shoes_name) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, FruitDisplayLib.HSVtoRGB(shoes_fraction * HUD_maximum_hue, HUD_colour_saturation * 1.0F, 1.0F), graphical_text_alpha, false);
	
	FruitDisplayLib.renderScaledStringAtPos(shoes_postfix, graphical_text_xpos + FruitDisplayLib.getStringWidth(shoes_prefix + shoes_name + shoes_value) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, FruitDisplayLib.HSVtoRGB(shoes_postfix_hue, shoes_postfix_saturation, shoes_postfix_luminosity), graphical_text_alpha, false);
      }
      
    }
    else
    {
      if(show_schematic && has_HUD_helmet)
      {
	// shoe 1:
	FruitDisplayLib.drawHollowRect(left_leg_xcentre - (shoe_width / 2.0F), shoe_ypos, shoe_width, shoe_height, 0.5F, FruitDisplayLib.HSVtoRGB(1.0F, 0.0F, 1.0F), armour_alpha);
	// shoe 2:
	FruitDisplayLib.drawHollowRect(right_leg_xcentre - (shoe_width / 2.0F), shoe_ypos, shoe_width, shoe_height, 0.5F, FruitDisplayLib.HSVtoRGB(1.0F, 0.0F, 1.0F), armour_alpha);
      }
    }
    
    if(tool != null)
    {
      if(show_schematic && has_HUD_helmet)
      {
	// draw the arms
	// arm ypos = torso_ypos
	// left arm xpos = armour_x_centre - (torso_width / 2.0F) - bodypart_spacing - arm_width;
	// right arm xpos = armour_x_centre + (torso_width / 2.0F) + bodypart_spacing;
	// arm 1:
	FruitDisplayLib.drawShadedRect(armour_x_centre - (torso_width / 2.0F) - bodypart_spacing - arm_width, torso_ypos, arm_width, arm_height, FruitDisplayLib.HSVtoRGB(tool_fraction * HUD_maximum_hue, 1.0F, 1.0F), armour_alpha);
	// arm 2:
	FruitDisplayLib.drawShadedRect(armour_x_centre + (torso_width / 2.0F) + bodypart_spacing, torso_ypos, arm_width, arm_height, FruitDisplayLib.HSVtoRGB(tool_fraction * HUD_maximum_hue, 1.0F, 1.0F), armour_alpha);
	
	
	if(tool_active)
	{
	  FruitDisplayLib.drawHollowRect(armour_x_centre - (torso_width / 2.0F) - bodypart_spacing - arm_width, torso_ypos, arm_width, arm_height, 2.0F, FruitDisplayLib.HSVtoRGB(1.0F, 0.0F, 1.0F), armour_alpha);
	  // arm 2:
	  FruitDisplayLib.drawHollowRect(armour_x_centre + (torso_width / 2.0F) + bodypart_spacing, torso_ypos, arm_width, arm_height, 2.0F, FruitDisplayLib.HSVtoRGB(1.0F, 0.0F, 1.0F), armour_alpha);
	}
      }
      
      
      if(HUD_position == 0)
      {
	graphical_text_xpos = box_border_spacing + armour_width + armour_width / 4.0F;
	graphical_text_ypos = y_offset + 30.0F * graphical_text_scaling;
	// 10.0F is the normal spacing between lines, so we scale it here
	// makes my life easier...
      }
      else if(HUD_position == 1)
      {
	graphical_text_xpos = (float)disp_width - box_border_spacing - armour_width - armour_width / 4.0F - tool_string_width;
	graphical_text_ypos = y_offset + 30.0F * graphical_text_scaling;
      }
      else if(HUD_position == 2)
      {
	graphical_text_xpos = box_border_spacing + armour_width + armour_width / 4.0F;
	// graphical_text_ypos = (float)torso_ypos - (float)bodypart_spacing;
	graphical_text_ypos = y_offset;
	// using 15.0F here, so that we get more spacing
	// not vital, but it'll look just that little bit nicer
      }
      else
      {
	graphical_text_xpos = (float)disp_width - box_border_spacing - armour_width - armour_width / 4.0F - tool_string_width;
	graphical_text_ypos = y_offset;
      }
      
      
      if(show_text)
      {
	FruitDisplayLib.drawShadedRect(graphical_text_xpos - 1.0F * graphical_text_scaling, graphical_text_ypos - 1.0F * graphical_text_scaling, tool_string_width + 2.0F * graphical_text_scaling, 10.0F * graphical_text_scaling, FruitDisplayLib.HSVtoRGB(0.0F, 0.0F, 0.0F), box_alpha);
	
	
	FruitDisplayLib.renderScaledStringAtPos(tool_prefix, graphical_text_xpos, graphical_text_ypos, graphical_text_scaling, FruitDisplayLib.HSVtoRGB(tool_prefix_hue, tool_prefix_saturation, tool_prefix_luminosity), graphical_text_alpha, false);
	
	FruitDisplayLib.renderScaledStringAtPos(tool_name, graphical_text_xpos + FruitDisplayLib.getStringWidth(tool_prefix) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, FruitDisplayLib.HSVtoRGB(HUD_maximum_hue, 0.0F, 1.0F), graphical_text_alpha, false);
	
	FruitDisplayLib.renderScaledStringAtPos(tool_value, graphical_text_xpos + FruitDisplayLib.getStringWidth(tool_prefix + tool_name) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, FruitDisplayLib.HSVtoRGB(tool_fraction * HUD_maximum_hue, HUD_colour_saturation * 1.0F, 1.0F), graphical_text_alpha, false);
	
	FruitDisplayLib.renderScaledStringAtPos(tool_postfix, graphical_text_xpos + FruitDisplayLib.getStringWidth(tool_prefix + tool_name + tool_value) * graphical_text_scaling, graphical_text_ypos, graphical_text_scaling, FruitDisplayLib.HSVtoRGB(tool_postfix_hue, tool_postfix_saturation, tool_postfix_luminosity), graphical_text_alpha, false);
	// tool string is level with the middle of the torso when in the top positions
	// and sits level with the bottom of the head when in the bottom positions
      }
      
    }
    else
    {
      if(show_schematic && has_HUD_helmet)
      {
	FruitDisplayLib.drawHollowRect(armour_x_centre - (torso_width / 2.0F) - bodypart_spacing - arm_width, torso_ypos, arm_width, arm_height, 0.5F, FruitDisplayLib.HSVtoRGB(1.0F, 0.0F, 1.0F), armour_alpha);
	// arm 2:
	FruitDisplayLib.drawHollowRect(armour_x_centre + (torso_width / 2.0F) + bodypart_spacing, torso_ypos, arm_width, arm_height, 0.5F, FruitDisplayLib.HSVtoRGB(1.0F, 0.0F, 1.0F), armour_alpha);
      }
    }
    
    // we now need to draw some text status lines giving the numerical condition
    // useful is HUD_position, which holds these values:
    // 0 = top-left, 1 = top-right, 2 = bottom-left, 3 = bottom-right
    // let's start with the top-left and use mirror symmetry here
    // hat text = level with the top of the head
    // shirt text = level with the top of the torso
    // trousers text = level with the top of the legs
    // shoes text = level with the top of the shoes
    // tool text = bottom part is level with the bottom part of the torso
    
    // spacing between text and armour box: box width / 4?
    // so graphical text start = box_border_spacing + armour_width + armour_width / 4.0F if HUD_position == 0 || HUD_position == 2
    // else graphical text start = disp_width - box_border_spacing - armour_width - armour_width / 4.0F - FruitDisplayLib.getStringWidth(<item>_words) * graphical_text_scaling
    // FruitDisplayLib.renderScaledStringAtPos("OMGTEST", 200.0F, 100.0F, 1.0F, FruitDisplayLib.HSVtoRGB(1.0F, 1.0F, 1.0F), armour_alpha);
    
    
  }
  
  
  

  
  public boolean onTickInGame(float tick, Minecraft minecraft)
  {
    // yeah, we're running all this code every single time the game ticks
    // die, computer, die...
    
    graphical_text_scaling = HUD_text_percentage;
    
    
    
    ScaledResolution scaledresolution = new ScaledResolution(minecraft.gameSettings, minecraft.displayWidth, minecraft.displayHeight);
    disp_width = scaledresolution.getScaledWidth();
    disp_height = scaledresolution.getScaledHeight();
    
    // ok, now we're going to make it configurable
    // we have this integer called HUD_position
    // if 0, it's in the top-left, if 1, it's in the top-right
    // if 2, it's in the bottom-left, if 3, it's in the bottom-right
    
    
    // status element size:
    // we'll have it 1/4 of the screen height and 1/8 of the width
    // too small, let's change it to 1/3 and 1/7
    
    // on second thoughts, we need a defined aspect ratio for the background
    // we'll fix the height with respect to the display height
    // and scale the width to that
    // how about we go for an aspect ratio of width = 0.75(height)?
    
    
    // we now need a way of scaling the graphical HUD
    // fortunately, I had the foresight to not only use variables instead of hardcoding it
    // but to chain the sizes off each other
    // so I can scale the armour height and everything else changes with it
    
    
    // armour_width = disp_width / 7;
    armour_height = (float)disp_height / 3.0F * HUD_size_percentage;
    // set size to zero if we're not showing the schematic
    // then I don't have to mess around with the drawing code so much
    armour_width = (armour_height * 3.0F) / 4.0F;
    // armour_width = (double)disp_height / 4.0F;
    // mathematically equivalent to above, but with less rounding error
    // rounding error re-introduced to make the scaling even easier
    
    
    x_offset = (HUD_position == 0 || HUD_position == 2) ? box_border_spacing : (float)disp_width - box_border_spacing - armour_width;
    
    y_offset = (HUD_position == 0 || HUD_position == 1) ? box_border_spacing : (float)disp_height - box_border_spacing - armour_height;
    
    
    // torso width = interior width / 3
    // torso height = interior height / 3
    torso_width = armour_width / 3.0F;
    torso_height = armour_height / 3.0F;
    
    // head height = head width = interior width / 5
    head_width = torso_width / 3.0F;
    // head will be automatically centred and is square
    
    arm_width = torso_width / 4.0F;
    arm_height = (torso_height * 3.0F) / 4.0F;
    // arms start level with the top of the torso
    
    leg_width = torso_width / 3.0F;
    leg_height = armour_height / 4.0F;
    
    // likewise, legs start level with the torso's outer vertical edges
    // parameter here is the vertical spacing between the legs and the torso
    // legs will be generated as a pair
    
    shoe_width = (torso_width * 2.0F) / 5.0F;
    shoe_height = leg_width;
    
    // currently, torso + head + leg + shoe heights = 75%
    // spacings: above, below, head-body, body-legs, legs-shoes
    // that's handy, we can make them all equal to 5% of the panel height
    
    bodypart_spacing = armour_height / 20.0F;
    border_spacing = bodypart_spacing;
    
    armour_x_centre = x_offset + (armour_width / 2.0F);
    torso_ypos = border_spacing + head_width + bodypart_spacing + y_offset;
    // above torso, we have: one head, one bodypart spacing and one border spacing
    // these two variables above tell us where we draw each body part
    // and change the centering
    // so don't forget to put in the offsets here
    
    left_leg_xcentre = armour_x_centre - (torso_width / 2.0F) + (leg_width / 2.0F);
    right_leg_xcentre = armour_x_centre + (torso_width / 2.0F) - (leg_width / 2.0F);
    shoe_ypos = torso_ypos + torso_height + leg_height + (2.0F * bodypart_spacing);
    
    
    // colours: use HSV with S and V at 100%
    // electric items can start at a nice deep blue, so that's H = 240/360
    // could start non-electric items at green, which is H = 120/360
    // but that might get a little confusing
    // depleted = red, which is H = 0/360
    // but we'll list actually depleted items as black (if they're electric)
    // no armour = hollow black
    // indestructible armour = white
    // green is actually half-way down, if we're using blue as max, so it might get a little misleading
    // ...meh, who cares - let's start at blue and work downwards from there
    
    // invalid values will come out of the function as (1,1,1), or white
    // perfect for the solar helmet, which gives an invalid value when tested for durability
    // so that we can take advantage of the "undefined" or NULL output from utility armours
    // RGB values outputted thus will range from 0 to 1 - perfect for my needs
    
    
    /*
    hat = minecraft.thePlayer.inventory.armorItemInSlot(0);
    shirt = minecraft.thePlayer.inventory.armorItemInSlot(1);
    trousers = minecraft.thePlayer.inventory.armorItemInSlot(2);
    shoes = minecraft.thePlayer.inventory.armorItemInSlot(3);
    */
    
    hat = minecraft.thePlayer.inventory.armorItemInSlot(3);
    shirt = minecraft.thePlayer.inventory.armorItemInSlot(2);
    trousers = minecraft.thePlayer.inventory.armorItemInSlot(1);
    shoes = minecraft.thePlayer.inventory.armorItemInSlot(0);
    // I got it backwards
    // how humiliating...
    
    
    tool = minecraft.thePlayer.inventory.getCurrentItem();
    
    // if(hat != null && hat.getItem() instanceof ItemArmorQuantumSuit)
    if(hat != null && hat.getItem().getClass().getName() == "ic2.common.ItemArmorQuantumSuit")
    {
      has_HUD_helmet = true;
      has_advanced_HUD_helmet = true;
    }
    else if(hat != null && (hat.getItem().getClass().getName() == "ic2.common.ItemArmorNanoSuit" || hat.getItem().getClass().getName() == "ic2.common.ItemArmorNightVisionGoggles"))
    //else if(hat != null && hat.getItem() instanceof ItemArmorNanoSuit)
    {
      has_HUD_helmet = true;
      has_advanced_HUD_helmet = false;
    }
    else
    {
      has_HUD_helmet = false;
      has_advanced_HUD_helmet = false;
    }
    
    
    // bit of a nasty hack, but it means that I don't need to rewrite the text positioning code
    
    if(!show_schematic || !has_HUD_helmet)
    {
      armour_height = 0.0F;
      armour_width = 0.0F;
      
      // this is a horrible hack to make the lower status text line up with the bottom of the screen
      // when the graphical HUD is disabled - otherwise, it hovers above it
      // it would be in the correct position if we had the graphical section
      // (high enough to avoid the quickbar and health displays)
      // but hovering above the bottom left without the graphical display
      if(HUD_position == 2 || HUD_position == 3)
      {
	y_offset = (float)disp_height - box_border_spacing - 40.0F * graphical_text_scaling;
	// number here: 30.0F = space from offset for text drawing + 10.0F for actual text height
      }
    }
    
    // these need to be zeroed out each tick to prevent unwanted persistence
    
    hat_active = false;
    shirt_active = false;
    trousers_active = false;
    shoes_active = false;
    tool_active = false;
    
    hat_prefix = "";
    shirt_prefix = "";
    trousers_prefix = "";
    shoes_prefix = "";
    tool_prefix = "";
    
    hat_postfix = "";
    shirt_postfix = "";
    trousers_postfix = "";
    shoes_postfix = "";
    tool_postfix = "";
    
    // we'll also reset the colour of the pre- and post-fix text to white
    // it can then be reassigned later at will
    
    
    hat_prefix_hue = 240.0F;
    shirt_prefix_hue = 240.0F;
    trousers_prefix_hue = 240.0F;
    shoes_prefix_hue = 240.0F;
    tool_prefix_hue = 240.0F;
    
    hat_prefix_saturation = 0.0F;
    shirt_prefix_saturation = 0.0F;
    trousers_prefix_saturation = 0.0F;
    shoes_prefix_saturation = 0.0F;
    tool_prefix_saturation = 0.0F;
    
    hat_prefix_luminosity = 1.0F;
    shirt_prefix_luminosity = 1.0F;
    trousers_prefix_luminosity = 1.0F;
    shoes_prefix_luminosity = 1.0F;
    tool_prefix_luminosity = 1.0F;
    
    
    hat_postfix_hue = 240.0F;
    shirt_postfix_hue = 240.0F;
    trousers_postfix_hue = 240.0F;
    shoes_postfix_hue = 240.0F;
    tool_postfix_hue = 240.0F;
    
    hat_postfix_saturation = 0.0F;
    shirt_postfix_saturation = 0.0F;
    trousers_postfix_saturation = 0.0F;
    shoes_postfix_saturation = 0.0F;
    tool_postfix_saturation = 0.0F;
    
    hat_postfix_luminosity = 1.0F;
    shirt_postfix_luminosity = 1.0F;
    trousers_postfix_luminosity = 1.0F;
    shoes_postfix_luminosity = 1.0F;
    tool_postfix_luminosity = 1.0F;
    
    
    
    gearFractions();
    
    gearWords();
    
    
    // if you want to modify the string prefixes and postfixes
    // here is the place to do it
    
    // in MC r1.3.2 and upwards, the Gravisuite chestplate now carries a boolean NBT tag called isFlyActive
    // (again, same class = gravisuite.ItemGraviChestPlate)
    // we'll read the NBT tag instead of sticking in a header file to read the fly status directly
    // this perhaps helps with future compatibility, since the boolean was moved to a client proxy
    // (course, it could have contained this tag before, but I didn't notice...)
    
    
    // future versions will hopefully have the mod author do things themselves
    // their respective items will be able to tell Armour HUD what prefix and postfix to use
    // along with their colours and whether the charge level should be displayed
    // this will most likely be achieved by using public variables or functions
    // I imagine that checking for the presence of a variable will present less overhead
    // than a function, but wrapper functions allow the user (me) to get read-only access
    // to private variables which are set by the mod to show its status
    
    
    if(shirt != null && shirt.getItem().getClass().getName() == "gravisuite.ItemGraviChestPlate")
    {
      //if(mod_GraviSuite.isFlyActiveByMod)
      //{
      if(shirt.stackTagCompound != null && shirt.stackTagCompound.hasKey("isFlyActive") && shirt.stackTagCompound.getBoolean("isFlyActive"))
      {
	shirt_postfix = shirt_postfix + " (On)";
	shirt_postfix_hue = 120.0F;
	shirt_postfix_saturation = 1.0F;
	shirt_active = true;
      }
      else
      {
	shirt_postfix = shirt_postfix + " (Off)";
	shirt_postfix_hue = 1.0F;
	shirt_postfix_saturation = 1.0F;
	shirt_active = false;
      }
    }
    
    /*
    
    // hey, maybe it'll work this time...
    
    // nope, still doesn't work
    // but hopefully, the IC2 team will have fixed the nanosabre not syncing
    // since, y'know, *everything* is multiplayer now...
    
    if(tool != null && tool.getItem().getClass().getName() == "ic2.common.ItemNanoSaber")
    {
	if(((ic2.common.ItemNanoSaber) tool).active)
	{
	  tool_postfix = tool_postfix + " (On)";
	  tool_postfix_hue = 120.0F;
	  tool_postfix_saturation = 1.0F;
	  tool_active = true;
	}
	else
	{
	  tool_postfix = tool_postfix + " (Off)";
	  tool_postfix_hue = 1.0F;
	  tool_postfix_saturation = 1.0F;
	  tool_active = false;
	}
    }
    
    */
    
    hat_string_width = FruitDisplayLib.getStringWidth(hat_prefix + hat_name + hat_value + hat_postfix) * graphical_text_scaling;
    shirt_string_width = FruitDisplayLib.getStringWidth(shirt_prefix + shirt_name + shirt_value + shirt_postfix) * graphical_text_scaling;
    trousers_string_width = FruitDisplayLib.getStringWidth(trousers_prefix + trousers_name + trousers_value + trousers_postfix) * graphical_text_scaling;
    shoes_string_width = FruitDisplayLib.getStringWidth(shoes_prefix + shoes_name + shoes_value + shoes_postfix) * graphical_text_scaling;
    tool_string_width = FruitDisplayLib.getStringWidth(tool_prefix + tool_name + tool_value + tool_postfix) * graphical_text_scaling;
    
    /*
    if(tool != null)
    {
      System.out.println("(Tool) Pre: " + tool_prefix + " Name: " + tool_name + " Val: " + tool_value + " Post: " + tool_postfix);
    }
    */
    
    if(HUD_position != 4 && !minecraft.isDebugInfoEnabled() && minecraft.isGuiEnabled() && minecraft.inGameHasFocus)
    {
      graphicalStatus(minecraft);
    }
    
    // see World.java. line 3706 (public List getEntitiesWithinAABB), can pass the relevant class to it
    // will be very useful for Upcoming Features (tm)
    // also see http://forums.bukkit.org/threads/monsters-in-an-area.7386/ for this function:
    
    // loc = thePlayer.getLocation();
    // but you might need to adjust for Bukkit code...
    
    // double x = loc.getX()+0.5;
    // double y = loc.getY()+0.5;
    // double z = loc.getZ()+0.5;
    // double radius = 10;
    
    // AxisAlignedBB bb = AxisAlignedBB.a(x-radius,y-radius,z-radius,x+radius,y+radius,z+radius);
    
    
    // FruitDisplayLib.renderScaledStringAtPos("QuantumSuit Helmet 9.85%", 200.0F, 100.0F, 0.6F, FruitDisplayLib.HSVtoRGB(1.0F, 1.0F, 1.0F), armour_alpha);
    
    // FruitDisplayLib.renderScaledStringAtPos("OMGTEST2", 200.0F, 160.0F, 0.6F, FruitDisplayLib.HSVtoRGB(1.0F, 0.0F, 1.0F), 1.0F);
    
    // test for rendering scaled strings to the display
    // it works, though it does look a little funky
    // probably blame this on the Unicode font looking different to the normal one
    
    // y'know what?
    // screw unicode
    // it's ruining the spacings
    
    
    return true;
  }
  
  
  public boolean clientSideRequired()
  {
    return false;
  }
  
  public boolean serverSideRequired()
  {
    return false;
  }
  
}
