/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.ModPatcher.asm;

import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.IClassTransformer;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import mistaqur.ModPatcher.asm.ModPatcherModContainer;

public class ClassOverridePatch
implements IClassTransformer {
    private LinkedList patches = new LinkedList();

    public void addClassOverride(String name, String hash, String path, File jar, String desc) {
        for (Entry entry : this.patches) {
            if (!entry.name.equals(name) || !entry.hash.equals(hash)) continue;
            throw new RuntimeException(String.format("Class override patch for class %s with hash %s already defined", name, hash));
        }
        this.patches.add(new Entry(name, hash, path, jar, desc));
    }

    public byte[] transform(String name, byte[] bytes) {
        String hash = ModPatcherModContainer.generateHash(bytes);
        for (Entry entry : this.patches) {
            if (!entry.name.equals(name) || !entry.hash.equals(hash)) continue;
            try {
                ZipFile zip = new ZipFile(entry.jar);
                ZipEntry ze = zip.getEntry(entry.path);
                if (ze == null) {
                    FMLRelaunchLog.info((String)"[ModPatcher] File \"%s\" not found in %s", (Object[])new Object[]{entry.path, entry.jar.getName()});
                } else {
                    InputStream zin = zip.getInputStream(ze);
                    bytes = ModPatcherModContainer.readFully(zin);
                    zin.close();
                    FMLRelaunchLog.info((String)"[ModPatcher] Apply class override patch to %s: %s", (Object[])new Object[]{name, entry.desc});
                }
                zip.close();
            }
            catch (Exception e) {
                FMLRelaunchLog.log((Level)Level.SEVERE, (Throwable)e, (String)"[ModPatcher] Error overriding %s with hash %s", (Object[])new Object[]{name, hash});
            }
            return bytes;
        }
        return bytes;
    }

    class Entry {
        String name;
        String hash;
        String path;
        File jar;
        String desc;

        public Entry(String name, String hash, String path, File jar, String desc) {
            this.name = name;
            this.hash = hash;
            this.path = path;
            this.jar = jar;
            this.desc = desc;
        }
    }
}

