/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.ModPatcher.asm;

import com.google.common.eventbus.EventBus;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import mistaqur.ModPatcher.asm.ClassOverridePatch;
import mistaqur.ModPatcher.asm.ModPatcherPlugin;
import mistaqur.ModPatcher.asm.ModPatcherTransformer;

public class ModPatcherModContainer
extends DummyModContainer {
    private static String version = "1.0.1";
    private static final String HEXES = "0123456789abcdef";

    public ModPatcherModContainer() {
        super(new ModMetadata());
        this.getMetadata();
    }

    public String getVersion() {
        return version;
    }

    public ModMetadata getMetadata() {
        ModMetadata meta = super.getMetadata();
        meta.modId = "mod_ModPatcher";
        meta.name = "Mod Patcher";
        meta.version = version;
        meta.authorList = Arrays.asList("mistaqur");
        meta.description = "Allow apply hotfixes to some mods.\n\u00a7f\n";
        meta.url = "https://bitbucket.org/mistaqur/modpatcher/wiki/Home";
        return meta;
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        return ModPatcherPlugin.active;
    }

    public static void loadPatches(File mcDir) {
        File patchDir = new File(mcDir, "modpatches");
        if (!patchDir.exists()) {
            patchDir.mkdir();
        }
        if (!patchDir.isDirectory()) {
            return;
        }
        FilenameFilter ff = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        };
        Object[] fileList = patchDir.listFiles(ff);
        if (fileList == null) {
            return;
        }
        Arrays.sort(fileList);
        ClassOverridePatch classOverridePatch = new ClassOverridePatch();
        ModPatcherTransformer.patches.add(classOverridePatch);
        for (Object file : fileList) {
            Attributes mfAttributes;
            JarFile jar;
            try {
                jar = new JarFile((File)file);
                mfAttributes = jar.getManifest().getMainAttributes();
            }
            catch (IOException ioe) {
                FMLRelaunchLog.log((Level)Level.SEVERE, (Throwable)ioe, (String)"[ModPatcher] Unable to read the patch jar file %s - ignoring", (Object[])new Object[]{((File)file).getName()});
                continue;
            }
            String patchListPath = mfAttributes.getValue("PatchList");
            String requiredVersion = mfAttributes.getValue("ModPatcherVersion");
            if (patchListPath == null || requiredVersion == null) {
                FMLRelaunchLog.warning((String)"[ModPatcher] The patch %s does not contain a valid jar manifest - it will be ignored", (Object[])new Object[]{((File)file).getName()});
                continue;
            }
            DefaultArtifactVersion reqVersion = new DefaultArtifactVersion(requiredVersion);
            if (reqVersion.compareTo((Object)new DefaultArtifactVersion(version)) > 0) {
                FMLRelaunchLog.warning((String)"[ModPatcher] The patch %s require newer version of ModPatcher - it will be ignored", (Object[])new Object[]{((File)file).getName()});
                continue;
            }
            ZipEntry entry = jar.getEntry(patchListPath);
            if (entry == null) {
                FMLRelaunchLog.warning((String)"[ModPatcher] The patch %s does not have a patch list %s - it will be ignored", (Object[])new Object[]{((File)file).getName(), patchListPath});
                continue;
            }
            try {
                String strRead;
                InputStream zin = jar.getInputStream(entry);
                InputStreamReader isr = new InputStreamReader(zin);
                BufferedReader readbuffer = new BufferedReader(isr);
                while ((strRead = readbuffer.readLine()) != null) {
                    if ((strRead = strRead.trim()).startsWith("#") || strRead.equals("")) continue;
                    String[] splitarray = strRead.split("\t");
                    if (splitarray[0].equals("ClassOverride")) {
                        if (splitarray.length != 5) {
                            FMLRelaunchLog.warning((String)"[ModPatcher] Invalid line \"%s\" in patch %s", (Object[])new Object[]{strRead, ((File)file).getName()});
                            continue;
                        }
                        if (jar.getEntry(splitarray[3]) == null) {
                            FMLRelaunchLog.warning((String)"[ModPatcher] Target class file \"%s\" not found in patch %s", (Object[])new Object[]{splitarray[3], ((File)file).getName()});
                            continue;
                        }
                        classOverridePatch.addClassOverride(splitarray[1], splitarray[2], splitarray[3], (File)file, splitarray[4]);
                        continue;
                    }
                    FMLRelaunchLog.warning((String)"[ModPatcher] Invalid line \"%s\" in patch %s", (Object[])new Object[]{strRead, ((File)file).getName()});
                }
                FMLRelaunchLog.info((String)"[ModPatcher] Loaded patch %s ", (Object[])new Object[]{((File)file).getName()});
                readbuffer.close();
                isr.close();
                zin.close();
                jar.close();
            }
            catch (IOException ioe) {
                FMLRelaunchLog.log((Level)Level.SEVERE, (Throwable)ioe, (String)"[ModPatcher] Unable to read the patch jar file %s - ignoring", (Object[])new Object[]{((File)file).getName()});
            }
        }
    }

    public static String generateHash(byte[] bytes) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(bytes);
            byte[] chksum = digest.digest();
            StringBuilder hex = new StringBuilder(2 * chksum.length);
            for (byte b : chksum) {
                hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
            }
            return hex.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] readFully(InputStream stream) throws IOException {
        int r;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(stream.available());
        while ((r = stream.read()) != -1) {
            bos.write(r);
        }
        return bos.toByteArray();
    }
}

